/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.utils;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.Set;

public final class ConvertUtils {
    private static final String NULL_STR = "null";
    public static final Set<String> TRUE_SET = CollectionUtils.set("y", "yes", "on", "true", "t");
    public static final Set<String> FALSE_SET = CollectionUtils.set("n", "no", "off", "false", "f");

    private ConvertUtils() {
    }

    public static int toInt(String val) {
        return ConvertUtils.toInt(val, 0);
    }

    public static int toInt(String val, int defaultValue) {
        if (StringUtils.equalsIgnoreCase(val, NULL_STR)) {
            return defaultValue;
        }
        if (StringUtils.isBlank(val)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException exception) {
            return defaultValue;
        }
    }

    public static long toLong(Object val) {
        if (val instanceof Long) {
            return (Long)val;
        }
        return ConvertUtils.toLong(val.toString());
    }

    public static long toLong(String val) {
        return ConvertUtils.toLong(val, 0L);
    }

    public static long toLong(String val, long defaultValue) {
        if (StringUtils.isBlank(val)) {
            return defaultValue;
        }
        try {
            return Long.parseLong(val);
        }
        catch (NumberFormatException exception) {
            return defaultValue;
        }
    }

    public static boolean toBoolean(String val, boolean defaultValue) {
        if (StringUtils.isBlank(val)) {
            return defaultValue;
        }
        return Boolean.parseBoolean(val);
    }

    public static boolean toBoolean(String str) {
        return Boolean.TRUE.equals(ConvertUtils.toBooleanObject(str));
    }

    public static Boolean toBooleanObject(String str) {
        String formatStr = (str == null ? "" : str).toLowerCase();
        if (TRUE_SET.contains(formatStr)) {
            return true;
        }
        if (FALSE_SET.contains(formatStr)) {
            return false;
        }
        return null;
    }
}

