/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.model;

import com.alibaba.hologres.client.Put;
import com.alibaba.hologres.client.Trace;
import com.alibaba.hologres.client.model.Column;
import com.alibaba.hologres.client.model.TableSchema;
import com.alibaba.hologres.org.postgresql.jdbc.ArrayUtil;
import com.alibaba.hologres.org.postgresql.jdbc.PgArray;
import com.alibaba.hologres.org.postgresql.util.PGobject;
import java.io.Serializable;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class Record
implements Serializable {
    TableSchema schema;
    Object[] values;
    BitSet bitSet;
    BitSet onlyInsertColumnSet;
    List<Object> attachmentList = null;
    Put.MutationType type = Put.MutationType.INSERT;
    int shardId = -1;
    long byteSize = 0L;
    transient List<CompletableFuture<Void>> putFutures;
    Trace trace;

    private Record(TableSchema schema, Object[] values, BitSet bitSet, BitSet onlyInsertColumnSet, List<Object> attachmentList, Put.MutationType type, long byteSize, int shardId) {
        this.schema = schema;
        this.values = values;
        this.bitSet = bitSet;
        this.onlyInsertColumnSet = onlyInsertColumnSet;
        this.attachmentList = attachmentList;
        this.type = type;
        this.byteSize = byteSize;
        this.shardId = shardId;
    }

    public Record clone() {
        return new Record(this.schema, (Object[])this.values.clone(), (BitSet)this.bitSet.clone(), (BitSet)this.onlyInsertColumnSet.clone(), null, this.type, this.byteSize, this.shardId);
    }

    public void startTrace() {
        this.trace = new Trace();
        this.trace.begin();
    }

    public void stepTrace(String name) {
        if (this.trace != null) {
            this.trace.step(name);
        }
    }

    public Trace getTrace() {
        return this.trace;
    }

    public Object[] getValues() {
        return this.values;
    }

    public Put.MutationType getType() {
        return this.type;
    }

    public void setType(Put.MutationType type) {
        this.type = type;
    }

    public TableSchema getSchema() {
        return this.schema;
    }

    public boolean isAllColumnSet() {
        return this.bitSet.stream().count() == (long)this.schema.getColumnSchema().length;
    }

    public static Record build(TableSchema schema) {
        return new Record(schema);
    }

    public Record(TableSchema schema) {
        this.schema = schema;
        this.bitSet = new BitSet(schema.getColumnSchema().length);
        this.onlyInsertColumnSet = new BitSet(schema.getColumnSchema().length);
        this.values = new Object[schema.getColumnSchema().length];
    }

    public boolean isSet(int index) {
        return this.bitSet.get(index);
    }

    public long getByteSize() {
        return this.byteSize;
    }

    private long getObjByteSize(int index, Object obj) {
        if (obj == null) {
            return 4L;
        }
        long ret = 0L;
        Column column = this.schema.getColumnSchema()[index];
        switch (column.getType()) {
            case -7: 
            case -6: 
            case 16: {
                ret = 1L;
                break;
            }
            case 5: {
                ret = 2L;
                break;
            }
            case -5: 
            case 8: {
                ret = 8L;
                break;
            }
            case 93: 
            case 2013: {
                ret = 12L;
                break;
            }
            case 2: 
            case 3: {
                ret = 24L;
                break;
            }
            case 1: 
            case 12: {
                ret = String.valueOf(obj).length();
                break;
            }
            case 2003: {
                if (obj instanceof int[]) {
                    ret = (long)((int[])obj).length * 4L;
                    break;
                }
                if (obj instanceof long[]) {
                    ret = (long)((long[])obj).length * 8L;
                    break;
                }
                if (obj instanceof float[]) {
                    ret = (long)((float[])obj).length * 4L;
                    break;
                }
                if (obj instanceof double[]) {
                    ret = (long)((double[])obj).length * 8L;
                    break;
                }
                if (obj instanceof boolean[]) {
                    ret = ((boolean[])obj).length;
                    break;
                }
                if (obj instanceof String[]) {
                    ret = ArrayUtil.getArrayLength((String[])obj);
                    break;
                }
                if (obj instanceof Object[]) {
                    ret = ArrayUtil.getArrayLength((Object[])obj, column.getTypeName());
                    break;
                }
                if (obj instanceof List) {
                    ret = ArrayUtil.getArrayLength((List)obj, column.getTypeName());
                    break;
                }
                if (obj instanceof PgArray) {
                    ret = ArrayUtil.getArrayLength((PgArray)obj);
                    break;
                }
                ret = 1024L;
                break;
            }
            default: {
                if ("json".equalsIgnoreCase(column.getTypeName()) || "jsonb".equalsIgnoreCase(column.getTypeName())) {
                    ret = String.valueOf(obj).length();
                    break;
                }
                if (obj instanceof PGobject) {
                    PGobject pObj = (PGobject)obj;
                    if (pObj.getValue() == null) break;
                    ret = pObj.getValue().length();
                    break;
                }
                ret = obj instanceof byte[] ? (long)((byte[])obj).length : 4L;
            }
        }
        return ret;
    }

    public void setObject(int index, Object obj) {
        Object old = this.values[index];
        long minus = 0L;
        if (this.isSet(index)) {
            minus = this.getObjByteSize(index, old);
        }
        long add = this.getObjByteSize(index, obj);
        this.byteSize = this.byteSize + add - minus;
        this.values[index] = obj;
        this.bitSet.set(index);
    }

    public Object getObject(int index) {
        return this.values[index];
    }

    public Object getObject(String columnName) {
        Integer index = this.schema.getColumnIndex(columnName);
        if (index == null) {
            throw new InvalidParameterException("can not found column named " + columnName);
        }
        return this.values[index];
    }

    public int[] getKeyIndex() {
        return this.schema.getKeyIndex();
    }

    public int getSize() {
        return this.schema.getColumnSchema().length;
    }

    public int getLength() {
        return (int)this.bitSet.stream().count();
    }

    public BitSet getBitSet() {
        return this.bitSet;
    }

    public BitSet getOnlyInsertColumnSet() {
        return this.onlyInsertColumnSet;
    }

    public void setPutFuture(CompletableFuture<Void> future) {
        if (this.putFutures != null) {
            throw new RuntimeException("setPutFuture should call ONLY ONCE");
        }
        this.putFutures = new ArrayList<CompletableFuture<Void>>(2);
        this.putFutures.add(future);
    }

    public void merge(Record record) {
        if (!this.schema.equals(record.schema)) {
            throw new InvalidParameterException("schema not match");
        }
        for (int i = 0; i < record.getSize(); ++i) {
            if (!record.isSet(i) || record.getOnlyInsertColumnSet().get(i)) continue;
            this.setObject(i, record.getObject(i));
        }
        this.addAttachmentList(record.attachmentList);
        if (this.putFutures == null) {
            if (record.putFutures != null) {
                this.putFutures = new ArrayList<CompletableFuture<Void>>(record.putFutures);
            }
        } else if (record.putFutures != null) {
            this.putFutures.addAll(record.putFutures);
        }
    }

    public void cover(Record record) {
        List<Object> origins;
        if (!this.schema.equals(record.schema)) {
            throw new InvalidParameterException("schema not match");
        }
        if (record.getAttachmentList() != null) {
            origins = record.getAttachmentList();
            if (this.getAttachmentList() != null) {
                origins.addAll(this.getAttachmentList());
            }
            this.setAttachmentList(origins);
        }
        if (record.putFutures != null) {
            origins = record.putFutures;
            if (this.putFutures != null) {
                origins.addAll(this.putFutures);
            }
            this.putFutures = origins;
        }
    }

    public List<CompletableFuture<Void>> getPutFutures() {
        return this.putFutures;
    }

    public List<Object> getAttachmentList() {
        return this.attachmentList;
    }

    public void setAttachmentList(List<Object> origin) {
        this.attachmentList = origin;
    }

    public void addAttachment(Object attachment) {
        if (attachment == null) {
            return;
        }
        if (this.attachmentList == null) {
            this.attachmentList = new ArrayList<Object>(1);
        }
        this.attachmentList.add(attachment);
    }

    public void addAttachmentList(List<Object> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        if (this.attachmentList == null) {
            this.attachmentList = new ArrayList<Object>(list);
        } else {
            this.attachmentList.addAll(list);
        }
    }

    public void changeToChildSchema(TableSchema schema) {
        this.schema = schema;
    }

    public void setShardId(int shardId) {
        this.shardId = shardId;
    }

    public int getShardId() {
        return this.shardId;
    }

    public String toString() {
        return "Record{schema=" + this.schema + ", values=" + Arrays.toString(this.values) + ", bitSet=" + this.bitSet + '}';
    }
}

