/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.model;

import com.alibaba.hologres.client.exception.HoloClientException;
import com.alibaba.hologres.client.impl.copy.CopyContext;
import com.alibaba.hologres.org.postgresql.jdbc.TimestampUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.NavigableMap;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;

public class ImportContext {
    private NavigableMap<Integer, Integer> shardMap;
    private CompletableFuture<Long> totalRowCount;
    private CompletableFuture<Long>[] rowCounts;
    private OutputStream[] ostreams;
    private CopyContext[] copyContexts;
    private int shardCount;

    public ImportContext(NavigableMap<Integer, Integer> shardMap, CompletableFuture<Long>[] rowCounts, CopyContext[] copyContexts, OutputStream[] ostreams, int shardCount) {
        this.shardMap = shardMap;
        this.rowCounts = rowCounts;
        this.ostreams = ostreams;
        this.copyContexts = copyContexts;
        this.totalRowCount = CompletableFuture.allOf(rowCounts).thenApply(ignore -> Stream.of(rowCounts).mapToLong(CompletableFuture::join).sum());
        this.shardCount = shardCount;
    }

    public CompletableFuture<Long> getRowCount() {
        return this.totalRowCount;
    }

    public OutputStream getOutputStream(int shardId) {
        return this.ostreams[this.shardMap.floorEntry(shardId).getValue()];
    }

    public void cancel() throws HoloClientException {
        try {
            for (CopyContext copyContext : this.copyContexts) {
                copyContext.cancel();
            }
        }
        catch (SQLException e) {
            throw HoloClientException.fromSqlException(e);
        }
    }

    public TimestampUtils getTimestampUtils() {
        return this.copyContexts[0].getConn().getTimestampUtils();
    }

    public int getShardCount() {
        return this.shardCount;
    }

    public void closeOstreams() throws IOException {
        for (OutputStream os : this.ostreams) {
            os.close();
        }
    }
}

