/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.impl.handler.jdbc;

import com.alibaba.hologres.client.impl.handler.jdbc.JdbcColumnValues;
import com.alibaba.hologres.org.postgresql.jdbc.TimestampUtils;
import com.alibaba.hologres.org.postgresql.util.PGTime;
import java.sql.SQLException;
import java.sql.Time;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.Date;

public class JdbcTimeColumnValues
extends JdbcColumnValues {
    String[] array;

    public JdbcTimeColumnValues(TimestampUtils timestampUtils, int rowCount) {
        super(timestampUtils, rowCount);
        this.array = new String[rowCount];
    }

    @Override
    public void doSet(int row, Object in) throws SQLException {
        if (in instanceof Time) {
            this.setTime(row, (Time)in);
        } else {
            Time tmpt;
            if (in instanceof Date) {
                tmpt = new Time(((Date)in).getTime());
            } else {
                if (in instanceof LocalTime) {
                    this.setTime(row, (LocalTime)in);
                    return;
                }
                tmpt = this.timestampUtils.toTime(this.getDefaultCalendar(), in.toString());
            }
            this.setTime(row, tmpt);
        }
    }

    private void setTime(int row, LocalTime localTime) throws SQLException {
        this.array[row] = this.timestampUtils.toString(localTime);
    }

    public void setTime(int row, Time x) throws SQLException {
        this.setTime(row, x, null);
    }

    public void setTime(int row, Time t, Calendar cal) throws SQLException {
        if (t == null) {
            return;
        }
        int oid = 0;
        if (t instanceof PGTime) {
            PGTime pgTime = (PGTime)t;
            if (pgTime.getCalendar() == null) {
                oid = 1083;
            } else {
                oid = 1266;
                cal = pgTime.getCalendar();
            }
        }
        if (cal == null) {
            cal = this.getDefaultCalendar();
        }
        this.array[row] = this.timestampUtils.toString(cal, t);
    }

    @Override
    public Object[] getArray() {
        return this.array;
    }
}

