/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.impl.collector;

import com.alibaba.hologres.client.HoloConfig;
import com.alibaba.hologres.client.Put;
import com.alibaba.hologres.client.impl.ExecutionPool;
import com.alibaba.hologres.client.impl.collector.BatchState;
import com.alibaba.hologres.client.model.Record;
import com.alibaba.hologres.client.model.RecordKey;
import com.alibaba.hologres.client.model.WriteMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordCollector {
    public static final Logger LOGGER = LoggerFactory.getLogger(RecordCollector.class);
    private final WriteMode mode;
    private final int maxRecords;
    private final long maxByteSize;
    private final long maxWaitTime;
    private final int shardCount;
    private ExecutionPool pool;
    Map<RecordKey, Record> deleteRecords = new HashMap<RecordKey, Record>();
    Map<RecordKey, Record> records = new HashMap<RecordKey, Record>();
    int size = 0;
    long byteSize = 0L;
    long startTimeMs = -1L;

    public RecordCollector(HoloConfig config, ExecutionPool pool, int shardCount) {
        this.mode = config.getWriteMode();
        this.maxRecords = config.getWriteBatchSize();
        this.maxByteSize = config.getWriteBatchByteSize();
        this.maxWaitTime = config.getWriteMaxIntervalMs();
        this.pool = pool;
        this.shardCount = shardCount;
    }

    public boolean append(Record record) {
        if (this.startTimeMs == -1L) {
            this.startTimeMs = System.currentTimeMillis();
        }
        Map<RecordKey, Record> recordMap = this.records;
        Map<RecordKey, Record> deleteMap = this.deleteRecords;
        RecordKey key = new RecordKey(record);
        Record origin = recordMap.get(key);
        if (origin != null) {
            block0 : switch (record.getType()) {
                case DELETE: {
                    Record deleteRecord = deleteMap.get(key);
                    if (null != deleteRecord) {
                        this.size += -1;
                        this.byteSize -= deleteRecord.getByteSize();
                        origin.cover(deleteRecord);
                    }
                    record.cover(origin);
                    recordMap.remove(key);
                    this.byteSize -= origin.getByteSize();
                    this.byteSize += record.getByteSize();
                    deleteMap.put(key, record);
                    break;
                }
                case INSERT: {
                    switch (this.mode) {
                        case INSERT_OR_UPDATE: {
                            this.byteSize -= origin.getByteSize();
                            origin.merge(record);
                            this.byteSize += origin.getByteSize();
                            origin.setType(Put.MutationType.INSERT);
                            break block0;
                        }
                        case INSERT_OR_IGNORE: {
                            origin.addAttachmentList(record.getAttachmentList());
                            break block0;
                        }
                        case INSERT_OR_REPLACE: {
                            record.cover(origin);
                            this.byteSize -= origin.getByteSize();
                            this.byteSize += record.getByteSize();
                            recordMap.put(key, record);
                        }
                    }
                }
            }
        } else {
            switch (record.getType()) {
                case DELETE: {
                    Record baseRecord = deleteMap.get(key);
                    if (baseRecord == null) {
                        ++this.size;
                    } else {
                        this.byteSize -= baseRecord.getByteSize();
                        record.cover(baseRecord);
                    }
                    this.byteSize += record.getByteSize();
                    deleteMap.put(key, record);
                    break;
                }
                case INSERT: {
                    Record baseRecord;
                    this.byteSize += record.getByteSize();
                    recordMap.put(key, record);
                    if (this.mode == WriteMode.INSERT_OR_REPLACE) {
                        baseRecord = deleteMap.get(key);
                        if (baseRecord == null) {
                            ++this.size;
                            break;
                        }
                        this.byteSize -= baseRecord.getByteSize();
                        record.cover(baseRecord);
                        deleteMap.remove(key);
                        break;
                    }
                    ++this.size;
                }
            }
        }
        BatchState bs = this.getBatchState();
        return bs != BatchState.NotEnough;
    }

    public BatchState getBatchState() {
        boolean isTimeWaitEnough;
        boolean isByteSizeEnough;
        boolean isSizeEnough;
        long afterLastCommit = System.currentTimeMillis() - this.startTimeMs;
        boolean bl = isSizeEnough = this.size >= this.maxRecords;
        if (isSizeEnough) {
            return BatchState.SizeEnough;
        }
        boolean bl2 = isByteSizeEnough = this.byteSize >= this.maxByteSize;
        if (isByteSizeEnough) {
            return BatchState.ByteSizeEnough;
        }
        boolean bl3 = isTimeWaitEnough = this.startTimeMs > -1L && afterLastCommit >= this.maxWaitTime;
        if (isTimeWaitEnough) {
            return BatchState.TimeWaitEnough;
        }
        boolean isEarlyCommit = false;
        if (this.size > 0 && (this.size & this.size - 1) == 0) {
            boolean totalByteSizeCondition;
            boolean byteSizeCondition;
            boolean timeCondition;
            boolean bl4 = timeCondition = this.startTimeMs > -1L && afterLastCommit * 5L > this.maxWaitTime * 2L;
            if (timeCondition) {
                return BatchState.TimeCondition;
            }
            boolean bl5 = byteSizeCondition = this.byteSize * 5L > this.maxByteSize * 2L;
            if (byteSizeCondition) {
                return BatchState.ByteSizeCondition;
            }
            long availableByteSize = this.pool.getAvailableByteSize();
            boolean bl6 = totalByteSizeCondition = this.byteSize * (long)this.shardCount > availableByteSize;
            if (totalByteSizeCondition) {
                return BatchState.TotalByteSizeCondition;
            }
            boolean bl7 = isEarlyCommit = timeCondition || byteSizeCondition || totalByteSizeCondition;
            if (isEarlyCommit) {
                if (timeCondition) {
                    LOGGER.debug("table {} earlyCommit[timeCondition].afterLastCommit({}) > 40% maxWaitTime({})", (Object)afterLastCommit, (Object)this.maxWaitTime);
                } else if (byteSizeCondition) {
                    LOGGER.debug("table {} earlyCommit[byteSizeCondition].byteSize({}) > 40% maxByteSize({})", (Object)this.byteSize, (Object)this.maxByteSize);
                } else {
                    LOGGER.debug("table {} earlyCommit[totalByteSizeCondition].afterLastCommit({}) > 40% availableByteSize({})", (Object)afterLastCommit, (Object)this.maxWaitTime);
                }
            }
        }
        return BatchState.NotEnough;
    }

    public int size() {
        return this.size;
    }

    public long getByteSize() {
        return this.byteSize;
    }

    public List<Record> getRecords() {
        ArrayList<Record> list = new ArrayList<Record>();
        list.addAll(this.deleteRecords.values());
        list.addAll(this.records.values());
        return list;
    }

    public void clear() {
        this.startTimeMs = -1L;
        this.size = 0;
        this.byteSize = 0L;
        this.records.clear();
        this.deleteRecords.clear();
    }
}

