/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.impl.collector;

import com.alibaba.hologres.client.HoloConfig;
import com.alibaba.hologres.client.impl.collector.CollectorStatistics;
import com.alibaba.hologres.client.impl.collector.ResizePolicy;
import com.alibaba.hologres.client.model.TableName;
import com.alibaba.hologres.client.utils.Metrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResizePolicy
implements ResizePolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultResizePolicy.class);
    private int maxShardCount;

    @Override
    public void init(HoloConfig config) {
        this.maxShardCount = config.getMaxShardCount();
    }

    @Override
    public int calculate(TableName tableName, CollectorStatistics stat, int currentSize, int workerCount, long currentNano) {
        int fullCount = stat.getFullBatchCount();
        int notFullCount = stat.getNotFullBatchCount();
        int load = (int)Metrics.registry().meter("write_cost_ms").getOneMinuteRate() / workerCount;
        int maxSize = this.maxShardCount > 0 ? this.maxShardCount : workerCount * 2;
        int newSize = currentSize;
        if (fullCount == 0) {
            newSize = currentSize > 1 ? currentSize / 2 : 1;
        } else if (fullCount * 2 <= notFullCount) {
            newSize = currentSize > 1 ? currentSize - 1 : currentSize;
        } else if (fullCount > notFullCount * 10 && load < 850) {
            newSize = (currentSize + maxSize) / 2;
        } else if (fullCount > notFullCount * 3 && load < 850) {
            int n = newSize = currentSize >= maxSize ? currentSize : maxSize + 1;
        }
        if (newSize != currentSize) {
            LOGGER.info("table {} size change {}->{}, fullCount = {}, notFullCount = {}, load = {} ", new Object[]{tableName, currentSize, newSize, fullCount, notFullCount, load});
        }
        return newSize;
    }
}

