/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client;

import com.alibaba.hologres.client.model.Record;
import com.alibaba.hologres.client.model.TableSchema;
import java.security.InvalidParameterException;
import java.util.concurrent.CompletableFuture;

public class Get {
    Record record;
    CompletableFuture<Record> future;
    boolean fullColumn = true;

    public Get(Record record) {
        this(record, true);
    }

    public Get(Record record, boolean isFullColumn) {
        this.record = record;
        this.fullColumn = isFullColumn;
    }

    @Deprecated
    public Get(TableSchema schema, Object[] keys) {
        if (schema.getPrimaryKeys().length == 0) {
            throw new InvalidParameterException("Get must have primary key");
        }
        if (keys == null || schema.getPrimaryKeys().length != keys.length) {
            throw new InvalidParameterException("expect primary key " + schema.getPrimaryKeys().length + " but input " + (keys == null ? 0 : keys.length));
        }
        this.record = Record.build(schema);
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] == null) {
                throw new InvalidParameterException("primary key cannot be null ,index:" + i + ",name:" + schema.getPrimaryKeys()[i]);
            }
            this.record.setObject(this.record.getKeyIndex()[i], keys[i]);
        }
    }

    public void addSelectColumn(int columnIndex) {
        if (!this.record.isSet(columnIndex)) {
            this.record.setObject(columnIndex, null);
        }
        this.fullColumn = false;
    }

    public void addSelectColumns(int[] columnIndex) {
        for (int i : columnIndex) {
            if (this.record.isSet(i)) continue;
            this.record.setObject(i, null);
        }
        this.fullColumn = false;
    }

    public void addSelectColumn(String columnName) {
        Integer columnIndex = this.getRecord().getSchema().getColumnIndex(columnName);
        if (null == columnIndex) {
            throw new InvalidParameterException("can not found column named " + columnName);
        }
        if (!this.record.isSet(columnIndex)) {
            this.record.setObject(columnIndex, null);
        }
        this.fullColumn = false;
    }

    public boolean isFullColumn() {
        return this.fullColumn;
    }

    public Record getRecord() {
        return this.record;
    }

    public CompletableFuture<Record> getFuture() {
        return this.future;
    }

    public void setFuture(CompletableFuture<Record> future) {
        this.future = future;
    }

    public static Builder newBuilder(TableSchema schema) {
        return new Builder(schema);
    }

    public static class Builder {
        private final TableSchema schema;
        private final Record record;
        private boolean fullColumn = true;

        public Builder(TableSchema schema) {
            this.schema = schema;
            this.record = Record.build(schema);
        }

        public Builder setPrimaryKey(String columnName, Object value) {
            if (!this.schema.isPrimaryKey(columnName)) {
                throw new InvalidParameterException(String.format("Column %s is not primary key.", columnName));
            }
            if (value == null) {
                throw new InvalidParameterException("Primary key should not be null.");
            }
            Integer index = this.schema.getColumnIndex(columnName);
            if (index == null) {
                throw new InvalidParameterException(String.format("Table %s does not have column %s.", this.schema.getTableName(), columnName));
            }
            this.record.setObject(index, value);
            return this;
        }

        public Builder withSelectedColumns(String[] columns) {
            for (String columnName : columns) {
                this.withSelectedColumn(columnName);
            }
            return this;
        }

        public Builder withSelectedColumn(String columnName) {
            Integer index = this.schema.getColumnIndex(columnName);
            if (index == null) {
                throw new InvalidParameterException(String.format("Table %s does not have column %s.", this.schema.getTableName(), columnName));
            }
            if (!this.record.isSet(index)) {
                this.record.setObject(index, null);
            }
            this.fullColumn = false;
            return this;
        }

        public Get build() {
            int[] nArray = this.schema.getKeyIndex();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer pkIndex = nArray[i];
                if (this.record.getObject(pkIndex) != null) continue;
                throw new InvalidParameterException("Primary key is not all set.");
            }
            return new Get(this.record, this.fullColumn);
        }
    }
}

