/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.blink.typeutils;

import com.alibaba.blink.dataformat.BinaryRow;
import com.alibaba.blink.memory.DataInputView;
import com.alibaba.blink.memory.DataOutputView;
import com.alibaba.blink.memory.MemorySegment;
import com.alibaba.blink.memory.MemorySegmentFactory;
import com.alibaba.blink.memory.runtime.AbstractPagedInputView;
import com.alibaba.blink.memory.runtime.AbstractPagedOutputView;
import com.alibaba.blink.typeinfo.Types;
import com.alibaba.blink.typeutils.AbstractRowSerializer;
import com.alibaba.blink.typeutils.TypeSerializer;
import com.alibaba.blink.util.Preconditions;
import java.io.IOException;
import java.util.Arrays;

public class BinaryRowSerializer
extends AbstractRowSerializer<BinaryRow> {
    private static final long serialVersionUID = 1L;
    public static final int LENGTH_SIZE_IN_BYTES = 4;
    private final int fixedLengthPartSize;

    public BinaryRowSerializer(Types ... types) {
        super(types);
        this.fixedLengthPartSize = BinaryRow.calculateFixPartSizeInBytes(this.numFields);
    }

    @Override
    public BinaryRow baseRowToBinary(BinaryRow baseRow) throws IOException {
        return baseRow;
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public TypeSerializer<BinaryRow> duplicate() {
        return new BinaryRowSerializer(this.types);
    }

    @Override
    public BinaryRow createInstance() {
        return new BinaryRow(this.numFields);
    }

    @Override
    public BinaryRow copy(BinaryRow from) {
        return this.copy(from, new BinaryRow(this.numFields));
    }

    @Override
    public BinaryRow copy(BinaryRow from, BinaryRow reuse) {
        return from.copy(reuse);
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(BinaryRow record, DataOutputView target) throws IOException {
        int sizeInBytes = record.getSizeInBytes();
        target.writeInt(sizeInBytes);
        int offset = record.getBaseOffset();
        for (MemorySegment segment : record.getAllSegments()) {
            int remain = segment.size() - offset;
            int copySize = Math.min(remain, sizeInBytes);
            target.write(segment, offset, copySize);
            sizeInBytes -= copySize;
            offset = 0;
        }
        if (sizeInBytes != 0) {
            throw new RuntimeException("No copy finished, this should be a bug, The remaining length is: " + sizeInBytes);
        }
    }

    @Override
    public BinaryRow deserialize(DataInputView source) throws IOException {
        BinaryRow row = new BinaryRow(this.numFields);
        int length = source.readInt();
        byte[] bytes = new byte[length];
        source.readFully(bytes);
        row.pointTo(MemorySegmentFactory.wrap(bytes), 0, length);
        return row;
    }

    @Override
    public BinaryRow deserialize(BinaryRow reuse, DataInputView source) throws IOException {
        MemorySegment segment = reuse.getMemorySegment();
        Preconditions.checkArgument(segment == null || reuse.getAllSegments().length == 1 && reuse.getBaseOffset() == 0);
        int length = source.readInt();
        if (segment == null || segment.size() < length) {
            segment = MemorySegmentFactory.wrap(new byte[length]);
        }
        source.readFully(segment.getHeapMemory(), 0, length);
        reuse.pointTo(segment, 0, length);
        return reuse;
    }

    @Override
    public int serializeToPages(BinaryRow record, AbstractPagedOutputView target) throws IOException {
        Preconditions.checkArgument(target.getHeaderLength() == 0);
        int sizeInBytes = record.getSizeInBytes();
        int skip = this.checkSkipWrite(target);
        if (record.getAllSegments().length == 1) {
            target.writeInt(sizeInBytes);
            target.write(record.getMemorySegment(), record.getBaseOffset(), sizeInBytes);
        } else {
            this.serializeToPagesSlow(record, target);
        }
        return skip;
    }

    private void serializeToPagesSlow(BinaryRow record, AbstractPagedOutputView out) throws IOException {
        out.writeInt(record.getSizeInBytes());
        int remainSize = record.getSizeInBytes();
        int posInSegOfRecord = record.getBaseOffset();
        for (MemorySegment segOfRecord : record.getAllSegments()) {
            int nWrite = Math.min(record.getMemorySegment().size() - posInSegOfRecord, remainSize);
            assert (nWrite > 0);
            out.write(segOfRecord, posInSegOfRecord, nWrite);
            posInSegOfRecord = 0;
            if ((remainSize -= nWrite) == 0) break;
        }
        Preconditions.checkArgument(remainSize == 0);
    }

    @Override
    public BinaryRow deserializeFromPages(AbstractPagedInputView source) throws IOException {
        throw new UnsupportedOperationException("Not support!");
    }

    @Override
    public BinaryRow deserializeFromPages(BinaryRow reuse, AbstractPagedInputView source) throws IOException {
        this.checkSkipRead(source);
        return this.deserialize(reuse, (DataInputView)source);
    }

    @Override
    public BinaryRow mapFromPages(AbstractPagedInputView source) throws IOException {
        BinaryRow row = this.createInstance();
        this.pointTo(row, source);
        return row;
    }

    @Override
    public BinaryRow mapFromPages(BinaryRow reuse, AbstractPagedInputView source) throws IOException {
        this.pointTo(reuse, source);
        return reuse;
    }

    private void pointTo(BinaryRow row, AbstractPagedInputView source) throws IOException {
        Preconditions.checkArgument(source.getHeaderLength() == 0);
        this.checkSkipRead(source);
        int length = source.readInt();
        if (length < 0) {
            throw new IOException(String.format("Read unexpected bytes in source of positionInSegment[%d] and limitInSegment[%d]", source.getCurrentPositionInSegment(), source.getCurrentSegmentLimit()));
        }
        int remainInSegment = source.getCurrentSegmentLimit() - source.getCurrentPositionInSegment();
        MemorySegment currSeg = source.getCurrentSegment();
        int currPosInSeg = source.getCurrentPositionInSegment();
        if (remainInSegment >= length) {
            row.pointTo(currSeg, currPosInSeg, length);
            source.skipBytesToRead(length);
        } else {
            this.pointToSlow(row, source, length, length - remainInSegment, currSeg, currPosInSeg);
        }
    }

    private void pointToSlow(BinaryRow row, AbstractPagedInputView source, int sizeInBytes, int remainLength, MemorySegment currSeg, int currPosInSeg) throws IOException {
        int div;
        int segmentSize = currSeg.size();
        int remainder = remainLength - segmentSize * (div = remainLength / segmentSize);
        int varSegSize = remainder == 0 ? div : div + 1;
        MemorySegment[] segments = new MemorySegment[varSegSize + 1];
        segments[0] = currSeg;
        for (int i = 1; i <= varSegSize; ++i) {
            source.advance();
            segments[i] = source.getCurrentSegment();
        }
        int remainLenInLastSeg = remainder == 0 ? segmentSize : remainder;
        source.skipBytesToRead(remainLenInLastSeg);
        row.pointTo(segments, currPosInSeg, sizeInBytes);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int length = source.readInt();
        target.writeInt(length);
        target.write(source, length);
    }

    public void copyFromPagesToView(AbstractPagedInputView source, DataOutputView target) throws IOException {
        this.checkSkipRead(source);
        int length = source.readInt();
        target.writeInt(length);
        target.write(source, length);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof BinaryRowSerializer && Arrays.equals((Object[])this.types, (Object[])((BinaryRowSerializer)obj).types);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof BinaryRowSerializer;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode((Object[])this.types);
    }

    public int getSerializedRowFixedPartLength() {
        return this.fixedLengthPartSize + 4;
    }

    private int checkSkipWrite(AbstractPagedOutputView out) throws IOException {
        int available = out.getSegmentSize() - out.getCurrentPositionInSegment();
        if (available < this.getSerializedRowFixedPartLength()) {
            out.advance();
            return available;
        }
        return 0;
    }

    public void checkSkipRead(AbstractPagedInputView source) throws IOException {
        int available = source.getCurrentSegmentLimit() - source.getCurrentPositionInSegment();
        if (available < this.getSerializedRowFixedPartLength()) {
            source.advance();
        }
    }
}

