/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.rm.datasource;

import com.alibaba.fescar.common.XID;
import com.alibaba.fescar.common.exception.FrameworkErrorCode;
import com.alibaba.fescar.common.exception.FrameworkException;
import com.alibaba.fescar.common.exception.NotSupportYetException;
import com.alibaba.fescar.common.exception.ShouldNeverHappenException;
import com.alibaba.fescar.common.executor.Initialize;
import com.alibaba.fescar.common.util.NetUtil;
import com.alibaba.fescar.core.context.RootContext;
import com.alibaba.fescar.core.exception.TransactionException;
import com.alibaba.fescar.core.exception.TransactionExceptionCode;
import com.alibaba.fescar.core.model.BranchStatus;
import com.alibaba.fescar.core.model.BranchType;
import com.alibaba.fescar.core.model.Resource;
import com.alibaba.fescar.core.model.ResourceManagerInbound;
import com.alibaba.fescar.core.protocol.ResultCode;
import com.alibaba.fescar.core.protocol.transaction.GlobalLockQueryRequest;
import com.alibaba.fescar.core.protocol.transaction.GlobalLockQueryResponse;
import com.alibaba.fescar.core.rpc.netty.NettyClientConfig;
import com.alibaba.fescar.core.rpc.netty.RmRpcClient;
import com.alibaba.fescar.core.rpc.netty.TmRpcClient;
import com.alibaba.fescar.discovery.loadbalance.LoadBalanceFactory;
import com.alibaba.fescar.discovery.registry.RegistryFactory;
import com.alibaba.fescar.rm.AbstractResourceManager;
import com.alibaba.fescar.rm.datasource.AsyncWorker;
import com.alibaba.fescar.rm.datasource.DataSourceProxy;
import com.alibaba.fescar.rm.datasource.undo.UndoLogManager;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceManager
extends AbstractResourceManager
implements Initialize {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSourceManager.class);
    private ResourceManagerInbound asyncWorker;
    private Map<String, Resource> dataSourceCache = new ConcurrentHashMap<String, Resource>();

    public void setAsyncWorker(ResourceManagerInbound asyncWorker) {
        this.asyncWorker = asyncWorker;
    }

    public boolean lockQuery(BranchType branchType, String resourceId, String xid, String lockKeys) throws TransactionException {
        try {
            GlobalLockQueryRequest request = new GlobalLockQueryRequest();
            request.setTransactionId(XID.getTransactionId((String)xid));
            request.setLockKey(lockKeys);
            request.setResourceId(resourceId);
            GlobalLockQueryResponse response = null;
            if (RootContext.inGlobalTransaction()) {
                response = (GlobalLockQueryResponse)RmRpcClient.getInstance().sendMsgWithResponse((Object)request);
            } else if (RootContext.requireGlobalLock()) {
                response = (GlobalLockQueryResponse)RmRpcClient.getInstance().sendMsgWithResponse(this.loadBalance(), (Object)request, (long)NettyClientConfig.getRpcRequestTimeout());
            } else {
                throw new RuntimeException("unknow situation!");
            }
            if (response.getResultCode() == ResultCode.Failed) {
                throw new TransactionException(response.getTransactionExceptionCode(), "Response[" + response.getMsg() + "]");
            }
            return response.isLockable();
        }
        catch (TimeoutException toe) {
            throw new TransactionException(TransactionExceptionCode.IO, "RPC Timeout", (Throwable)toe);
        }
        catch (RuntimeException rex) {
            throw new TransactionException(TransactionExceptionCode.LockableCheckFailed, "Runtime", (Throwable)rex);
        }
    }

    private String loadBalance() {
        InetSocketAddress address = null;
        try {
            List inetSocketAddressList = RegistryFactory.getInstance().lookup(TmRpcClient.getInstance().getTransactionServiceGroup());
            address = (InetSocketAddress)LoadBalanceFactory.getInstance().select(inetSocketAddressList);
        }
        catch (Exception ignore) {
            LOGGER.error(ignore.getMessage());
        }
        if (address == null) {
            throw new FrameworkException(FrameworkErrorCode.NoAvailableService);
        }
        return NetUtil.toStringAddress((InetSocketAddress)address);
    }

    public static DataSourceManager get() {
        return SingletonHolder.INSTANCE;
    }

    public static void set(DataSourceManager mock) {
        SingletonHolder.INSTANCE = mock;
    }

    public synchronized void initAsyncWorker(ResourceManagerInbound asyncWorker) {
        this.setAsyncWorker(asyncWorker);
    }

    public DataSourceManager() {
    }

    public DataSourceManager(boolean isInit) {
        if (isInit) {
            this.init();
        }
    }

    public void init() {
        AsyncWorker asyncWorker = new AsyncWorker();
        asyncWorker.init();
        this.initAsyncWorker(asyncWorker);
    }

    public void registerResource(Resource resource) {
        DataSourceProxy dataSourceProxy = (DataSourceProxy)resource;
        this.dataSourceCache.put(dataSourceProxy.getResourceId(), dataSourceProxy);
        super.registerResource((Resource)dataSourceProxy);
    }

    public void unregisterResource(Resource resource) {
        throw new NotSupportYetException("unregister a resource");
    }

    public DataSourceProxy get(String resourceId) {
        return (DataSourceProxy)this.dataSourceCache.get(resourceId);
    }

    public BranchStatus branchCommit(BranchType branchType, String xid, long branchId, String resourceId, String applicationData) throws TransactionException {
        return this.asyncWorker.branchCommit(branchType, xid, branchId, resourceId, applicationData);
    }

    public BranchStatus branchRollback(BranchType branchType, String xid, long branchId, String resourceId, String applicationData) throws TransactionException {
        DataSourceProxy dataSourceProxy = this.get(resourceId);
        if (dataSourceProxy == null) {
            throw new ShouldNeverHappenException();
        }
        try {
            UndoLogManager.undo(dataSourceProxy, xid, branchId);
        }
        catch (TransactionException te) {
            if (te.getCode() == TransactionExceptionCode.BranchRollbackFailed_Unretriable) {
                return BranchStatus.PhaseTwo_RollbackFailed_Unretryable;
            }
            return BranchStatus.PhaseTwo_RollbackFailed_Retryable;
        }
        return BranchStatus.PhaseTwo_Rollbacked;
    }

    public Map<String, Resource> getManagedResources() {
        return this.dataSourceCache;
    }

    public BranchType getBranchType() {
        return BranchType.AT;
    }

    private static class SingletonHolder {
        private static DataSourceManager INSTANCE = new DataSourceManager(true);

        private SingletonHolder() {
        }
    }
}

