/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.spring6.data.mongodb;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.util.Fnv;
import java.lang.reflect.Type;
import org.springframework.data.mongodb.core.geo.GeoJsonPoint;

public class GeoJsonPointReader
implements ObjectReader<GeoJsonPoint> {
    public static final GeoJsonPointReader INSTANCE = new GeoJsonPointReader();
    static final long HASH_TYPE = Fnv.hashCode64((String)"type");
    static final long HASH_POINT = Fnv.hashCode64((String)"Point");
    static final long HASH_COORDINATES = Fnv.hashCode64((String)"coordinates");

    public GeoJsonPoint readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        if (jsonReader.nextIfNull()) {
            return null;
        }
        jsonReader.nextIfObjectStart();
        double x = 0.0;
        double y = 0.0;
        while (!jsonReader.nextIfObjectEnd()) {
            long nameHashCode = jsonReader.readFieldNameHashCode();
            if (nameHashCode == HASH_TYPE) {
                long valueHashCode = jsonReader.readValueHashCode();
                if (valueHashCode == HASH_POINT) continue;
                throw new JSONException("not support input type : " + jsonReader.getString());
            }
            if (nameHashCode == HASH_COORDINATES) {
                boolean match = jsonReader.nextIfMatch('[');
                if (!match) {
                    throw new JSONException("coordinates not support input " + jsonReader.current());
                }
                x = jsonReader.readDoubleValue();
                y = jsonReader.readDoubleValue();
                match = jsonReader.nextIfMatch(']');
                if (!match) {
                    throw new JSONException("coordinates not support input " + jsonReader.current());
                }
                jsonReader.nextIfMatch(',');
                continue;
            }
            jsonReader.skipValue();
        }
        jsonReader.nextIfMatch(',');
        return new GeoJsonPoint(x, y);
    }
}

