/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.http.matcher;

import com.alibaba.cloud.dubbo.http.matcher.AbstractHttpRequestMatcher;
import com.alibaba.cloud.dubbo.http.matcher.ConsumeMediaTypeExpression;
import com.alibaba.cloud.dubbo.http.matcher.HeaderExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.MediaType;

public class HttpRequestConsumersMatcher
extends AbstractHttpRequestMatcher {
    private final List<ConsumeMediaTypeExpression> expressions;

    public HttpRequestConsumersMatcher(String ... consumes) {
        this(consumes, (String[])null);
    }

    public HttpRequestConsumersMatcher(String[] consumes, String[] headers) {
        this(HttpRequestConsumersMatcher.parseExpressions(consumes, headers));
    }

    private HttpRequestConsumersMatcher(Collection<ConsumeMediaTypeExpression> expressions) {
        this.expressions = new ArrayList<ConsumeMediaTypeExpression>(expressions);
        Collections.sort(this.expressions);
    }

    private static Set<ConsumeMediaTypeExpression> parseExpressions(String[] consumes, String[] headers) {
        LinkedHashSet<ConsumeMediaTypeExpression> result = new LinkedHashSet<ConsumeMediaTypeExpression>();
        if (headers != null) {
            for (String header : headers) {
                HeaderExpression expr = new HeaderExpression(header);
                if (!"Content-Type".equalsIgnoreCase(expr.name) || expr.value == null) continue;
                for (MediaType mediaType : MediaType.parseMediaTypes((String)((String)expr.value))) {
                    result.add(new ConsumeMediaTypeExpression(mediaType, expr.negated));
                }
            }
        }
        for (String consume : consumes) {
            result.add(new ConsumeMediaTypeExpression(consume));
        }
        return result;
    }

    @Override
    public boolean match(HttpRequest request) {
        if (this.expressions.isEmpty()) {
            return true;
        }
        HttpHeaders httpHeaders = request.getHeaders();
        MediaType contentType = httpHeaders.getContentType();
        if (contentType == null) {
            contentType = MediaType.APPLICATION_OCTET_STREAM;
        }
        for (ConsumeMediaTypeExpression expression : this.expressions) {
            if (expression.match(contentType)) continue;
            return false;
        }
        return true;
    }

    protected Collection<ConsumeMediaTypeExpression> getContent() {
        return this.expressions;
    }

    @Override
    protected String getToStringInfix() {
        return " || ";
    }
}

