/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.seata.web;

import io.seata.core.context.RootContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;

public class SeataHandlerInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SeataHandlerInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String xid = RootContext.getXID();
        String rpcXid = request.getHeader("TX_XID");
        if (log.isDebugEnabled()) {
            log.debug("xid in RootContext {} xid in RpcContext {}", (Object)xid, (Object)rpcXid);
        }
        if (xid == null && rpcXid != null) {
            RootContext.bind((String)rpcXid);
            if (log.isDebugEnabled()) {
                log.debug("bind {} to RootContext", (Object)rpcXid);
            }
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception e) {
        String rpcXid = request.getHeader("TX_XID");
        if (StringUtils.isEmpty((Object)rpcXid)) {
            return;
        }
        String unbindXid = RootContext.unbind();
        if (log.isDebugEnabled()) {
            log.debug("unbind {} from RootContext", (Object)unbindXid);
        }
        if (!rpcXid.equalsIgnoreCase(unbindXid)) {
            log.warn("xid in change during RPC from {} to {}", (Object)rpcXid, (Object)unbindXid);
            if (unbindXid != null) {
                RootContext.bind((String)unbindXid);
                log.warn("bind {} back to RootContext", (Object)unbindXid);
            }
        }
    }
}

