/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.worldbankdata;

import com.alibaba.cloud.ai.toolcalling.common.JsonParseTool;
import com.alibaba.cloud.ai.toolcalling.common.WebClientTool;
import com.alibaba.cloud.ai.toolcalling.common.interfaces.SearchService;
import com.alibaba.cloud.ai.toolcalling.worldbankdata.WorldBankDataProperties;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class WorldBankDataService
implements SearchService,
Function<Request, Response> {
    private static final Logger log = LoggerFactory.getLogger(WorldBankDataService.class);
    private final WebClientTool webClientTool;
    private final JsonParseTool jsonParseTool;
    private final WorldBankDataProperties properties;

    public WorldBankDataService(WebClientTool webClientTool, JsonParseTool jsonParseTool, WorldBankDataProperties properties) {
        this.webClientTool = webClientTool;
        this.jsonParseTool = jsonParseTool;
        this.properties = properties;
    }

    public SearchService.Response query(String query) {
        return this.apply(Request.simpleQuery(query));
    }

    @Override
    public Response apply(Request request) {
        try {
            String endpoint = this.buildEndpoint(request);
            MultiValueMap<String, String> params = this.buildQueryParams(request);
            log.debug("World Bank API endpoint: {}, params: {}", (Object)endpoint, params);
            String responseStr = (String)this.webClientTool.get(endpoint, params).block();
            log.debug("World Bank API response: {}", (Object)responseStr);
            List rawResponse = (List)this.jsonParseTool.jsonToObject(responseStr, (TypeReference)new TypeReference<List<Object>>(){});
            if (rawResponse.size() >= 2) {
                List dataList = (List)rawResponse.get(1);
                return this.parseResponse(dataList, request);
            }
            return new Response(new ArrayList<DataResult>());
        }
        catch (Exception e) {
            log.error("World Bank Data Service request error: ", (Throwable)e);
            throw new RuntimeException("Failed to fetch World Bank data: " + e.getMessage(), e);
        }
    }

    private String buildEndpoint(Request request) {
        StringBuilder endpoint = new StringBuilder();
        if (StringUtils.hasText((String)request.country()) && StringUtils.hasText((String)request.indicator())) {
            endpoint.append("/country/").append(request.country()).append("/indicator/").append(request.indicator());
        } else if (StringUtils.hasText((String)request.indicator())) {
            if ("metadata".equals(request.queryType())) {
                endpoint.append("/indicator/").append(request.indicator());
            } else {
                endpoint.append("/country/all/indicator/").append(request.indicator());
            }
        } else if (StringUtils.hasText((String)request.country())) {
            endpoint.append("/country/").append(request.country());
        } else {
            endpoint.append("/indicator");
        }
        return endpoint.toString();
    }

    private MultiValueMap<String, String> buildQueryParams(Request request) {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"format", (Object)this.properties.getFormat());
        params.add((Object)"per_page", (Object)String.valueOf(request.perPage() != null ? request.perPage().intValue() : this.properties.getPerPage()));
        if (StringUtils.hasText((String)request.dateRange())) {
            params.add((Object)"date", (Object)request.dateRange());
        }
        if (request.page() != null && request.page() > 0) {
            params.add((Object)"page", (Object)String.valueOf(request.page()));
        }
        if (request.mrv() != null && request.mrv() > 0) {
            params.add((Object)"mrv", (Object)String.valueOf(request.mrv()));
        }
        return params;
    }

    private Response parseResponse(List<Map<String, Object>> dataList, Request request) {
        ArrayList<DataResult> results = new ArrayList<DataResult>();
        for (Map<String, Object> item : dataList) {
            if (item == null) continue;
            String title = this.extractTitle(item, request);
            String description = this.extractDescription(item, request);
            String url = this.buildDataUrl(item, request);
            results.add(new DataResult(title, description, url, item.get("value")));
        }
        return new Response(results);
    }

    private String extractTitle(Map<String, Object> item, Request request) {
        Object countryObj;
        if (StringUtils.hasText((String)request.indicator()) && (countryObj = item.get("country")) instanceof Map) {
            Map country = (Map)countryObj;
            String countryName = (String)country.get("value");
            Object indicatorObj = item.get("indicator");
            if (indicatorObj instanceof Map) {
                Map indicator = (Map)indicatorObj;
                String indicatorName = (String)indicator.get("value");
                return countryName + " - " + indicatorName;
            }
            return countryName;
        }
        return item.getOrDefault("name", item.getOrDefault("value", "")).toString();
    }

    private String extractDescription(Map<String, Object> item, Request request) {
        Object sourceNote;
        StringBuilder desc = new StringBuilder();
        Object year = item.get("date");
        Object value = item.get("value");
        if (year != null) {
            desc.append("\u5e74\u4efd: ").append(year);
        }
        if (value != null) {
            if (desc.length() > 0) {
                desc.append(", ");
            }
            desc.append("\u6570\u503c: ").append(value);
        }
        if ((sourceNote = item.get("sourceNote")) != null) {
            if (desc.length() > 0) {
                desc.append(". ");
            }
            desc.append(sourceNote.toString());
        }
        return desc.toString();
    }

    private String buildDataUrl(Map<String, Object> item, Request request) {
        return "https://data.worldbank.org/";
    }

    @JsonClassDescription(value="World Bank Data Request for querying development indicators and country data.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Request(@JsonProperty(required=true, value="query") @JsonPropertyDescription(value="Search query - can be indicator code (e.g., 'SP.POP.TOTL'), country code (e.g., 'CHN'), or search terms") String query, @JsonProperty(value="country") @JsonPropertyDescription(value="Country code (e.g., 'CHN' for China, 'USA' for United States, 'all' for all countries)") String country, @JsonProperty(value="indicator") @JsonPropertyDescription(value="Indicator code (e.g., 'SP.POP.TOTL' for Population, 'NY.GDP.MKTP.CD' for GDP)") String indicator, @JsonProperty(value="dateRange") @JsonPropertyDescription(value="Date range for data (e.g., '2020', '2018:2022', 'YTD:2023')") String dateRange, @JsonProperty(value="queryType", defaultValue="data") @JsonPropertyDescription(value="Type of query: 'data' for indicator data, 'metadata' for indicator information, 'country' for country info") String queryType, @JsonProperty(value="page", defaultValue="1") @JsonPropertyDescription(value="Page number for pagination") Integer page, @JsonProperty(value="perPage", defaultValue="10") @JsonPropertyDescription(value="Number of results per page (max 100)") Integer perPage, @JsonProperty(value="mrv") @JsonPropertyDescription(value="Most recent values count (e.g., 5 for last 5 available data points)") Integer mrv) implements SearchService.Request
    {
        public String getQuery() {
            return this.query();
        }

        public static Request simpleQuery(String query) {
            if (query.contains(".") && query.length() > 5) {
                return new Request(query, "all", query, null, "data", 1, 10, null);
            }
            if (query.length() == 3 && query.toUpperCase().equals(query)) {
                return new Request(query, query, null, null, "country", 1, 10, null);
            }
            return new Request(query, null, null, null, "data", 1, 10, null);
        }
    }

    @JsonClassDescription(value="World Bank Data Response")
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record Response(@JsonProperty(value="results") List<DataResult> results) implements SearchService.Response
    {
        public SearchService.SearchResult getSearchResult() {
            return new SearchService.SearchResult(this.results().stream().map(item -> new SearchService.SearchContent(item.title(), item.description(), item.url(), null)).toList());
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public record DataResult(String title, String description, String url, Object value) {
    }
}

