/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.tripadvisor;

import com.alibaba.cloud.ai.toolcalling.common.CommonToolCallProperties;
import com.alibaba.cloud.ai.toolcalling.common.JsonParseTool;
import com.alibaba.cloud.ai.toolcalling.common.WebClientTool;
import com.alibaba.cloud.ai.toolcalling.tripadvisor.TripAdvisorProperties;
import com.alibaba.cloud.ai.toolcalling.tripadvisor.TripAdvisorService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Description;

@Configuration
@EnableConfigurationProperties(value={TripAdvisorProperties.class})
@ConditionalOnClass(value={TripAdvisorService.class})
@ConditionalOnProperty(prefix="spring.ai.alibaba.toolcalling.tripadvisor", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class TripAdvisorAutoConfiguration {
    @Bean(name={"tripAdvisor"})
    @ConditionalOnMissingBean
    @Description(value="Provides a TripAdvisorService bean for accessing TripAdvisor Content API for location details and search.")
    public TripAdvisorService tripAdvisor(TripAdvisorProperties properties, JsonParseTool jsonParseTool) {
        WebClientTool webClientTool = WebClientTool.builder((JsonParseTool)jsonParseTool, (CommonToolCallProperties)properties).httpHeadersConsumer(httpHeaders -> {
            httpHeaders.add("Accept", "application/json");
            httpHeaders.add("User-Agent", "Spring-AI-Alibaba-TripAdvisor/1.0");
            if (properties.getReferer() != null) {
                httpHeaders.add("Referer", properties.getReferer());
            }
        }).build();
        return new TripAdvisorService(jsonParseTool, webClientTool, properties);
    }
}

