/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.searches;

import com.alibaba.cloud.ai.toolcalling.common.interfaces.SearchService;
import com.alibaba.cloud.ai.toolcalling.searches.SearchEnum;
import java.util.Arrays;
import java.util.Optional;
import org.springframework.context.ApplicationContext;

public final class SearchUtil {
    private SearchUtil() {
    }

    public static Optional<SearchService> getAvailableSearchService(ApplicationContext context) {
        String toolName = SearchUtil.getAvailableSearchToolName(context).orElse(null);
        if (toolName == null) {
            return Optional.empty();
        }
        return SearchUtil.getSearchService(context, toolName);
    }

    public static Optional<String> getAvailableSearchToolName(ApplicationContext context) {
        return Arrays.stream(SearchEnum.values()).map(SearchEnum::getToolName).filter(arg_0 -> ((ApplicationContext)context).containsBean(arg_0)).findFirst();
    }

    public static Optional<SearchService> getSearchService(ApplicationContext context, String toolName) {
        try {
            return Optional.of((SearchService)context.getBean(toolName, SearchService.class));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

