/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.metaso;

import com.alibaba.cloud.ai.toolcalling.common.CommonToolCallProperties;
import com.alibaba.cloud.ai.toolcalling.common.JsonParseTool;
import com.alibaba.cloud.ai.toolcalling.common.WebClientTool;
import com.alibaba.cloud.ai.toolcalling.metaso.MetasoProperties;
import com.alibaba.cloud.ai.toolcalling.metaso.MetasoService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Description;

@Configuration
@EnableConfigurationProperties(value={MetasoProperties.class})
@ConditionalOnProperty(prefix="spring.ai.alibaba.toolcalling.metaso", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class MetasoAutoConfiguration {
    @Bean(name={"metasoService"})
    @ConditionalOnMissingBean
    @Description(value="Metaso AI Web Search Service")
    public MetasoService metasoService(JsonParseTool jsonParseTool, MetasoProperties properties) {
        return new MetasoService(WebClientTool.builder((JsonParseTool)jsonParseTool, (CommonToolCallProperties)properties).httpHeadersConsumer(httpHeaders -> {
            httpHeaders.add("Content-Type", "application/json");
            httpHeaders.add("Authorization", "Bearer " + properties.getApiKey());
        }).build(), jsonParseTool, properties);
    }
}

