/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.googlescholar;

import com.alibaba.cloud.ai.toolcalling.common.CommonToolCallProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="spring.ai.alibaba.toolcalling.googlescholar")
public class GoogleScholarProperties
extends CommonToolCallProperties {
    private int numResults = 10;
    private String language = "en";
    private boolean includeCitations = true;
    private int timeout = 30000;

    public GoogleScholarProperties() {
        super("https://scholar.google.com");
    }

    public int getNumResults() {
        return this.numResults;
    }

    public void setNumResults(int numResults) {
        this.numResults = Math.min(numResults, 20);
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public boolean isIncludeCitations() {
        return this.includeCitations;
    }

    public void setIncludeCitations(boolean includeCitations) {
        this.includeCitations = includeCitations;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

