/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.aliyunaisearch;

import com.alibaba.cloud.ai.toolcalling.aliyunaisearch.AliyunAiSearchProperties;
import com.alibaba.cloud.ai.toolcalling.aliyunaisearch.AliyunAiSearchService;
import com.alibaba.cloud.ai.toolcalling.common.CommonToolCallProperties;
import com.alibaba.cloud.ai.toolcalling.common.JsonParseTool;
import com.alibaba.cloud.ai.toolcalling.common.WebClientTool;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Description;

@Configuration
@EnableConfigurationProperties(value={AliyunAiSearchProperties.class})
@ConditionalOnProperty(prefix="spring.ai.alibaba.toolcalling.aliyunaisearch", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class AliyunAiSearchAutoConfiguration {
    @Bean(name={"aliyunAiSearch"})
    @ConditionalOnMissingBean
    @Description(value="Aliyun AI Web Search Service")
    public AliyunAiSearchService aliyunAiSearchService(JsonParseTool jsonParseTool, AliyunAiSearchProperties properties) {
        return new AliyunAiSearchService(WebClientTool.builder((JsonParseTool)jsonParseTool, (CommonToolCallProperties)properties).httpHeadersConsumer(httpHeaders -> {
            httpHeaders.add("Content-Type", "application/json");
            httpHeaders.add("Authorization", "Bearer " + properties.getApiKey());
        }).build(), jsonParseTool, properties);
    }
}

