/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.enums.RetryOperationReasonEnum;
import com.aizuda.snailjob.common.core.enums.RetryTaskStatusEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.model.request.RetryArgsDeserializeRequest;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.retry.task.convert.RetryConverter;
import com.aizuda.snailjob.server.retry.task.dto.TaskStopJobDTO;
import com.aizuda.snailjob.server.retry.task.support.handler.RetryTaskStopHandler;
import com.aizuda.snailjob.server.service.handler.RetryArgsDeserializeHandler;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.event.WsSendEvent;
import com.aizuda.snailjob.server.web.model.request.RetryTaskLogMessageQueryVO;
import com.aizuda.snailjob.server.web.model.request.RetryTaskQueryVO;
import com.aizuda.snailjob.server.web.model.request.UserSessionVO;
import com.aizuda.snailjob.server.web.model.response.RetryResponseWebVO;
import com.aizuda.snailjob.server.web.model.response.RetryTaskResponseVO;
import com.aizuda.snailjob.server.web.service.RetryTaskService;
import com.aizuda.snailjob.server.web.service.RetryWebService;
import com.aizuda.snailjob.server.web.service.convert.RetryTaskLogResponseVOConverter;
import com.aizuda.snailjob.server.web.service.convert.RetryTaskResponseVOConverter;
import com.aizuda.snailjob.server.web.timer.LogTimerWheel;
import com.aizuda.snailjob.server.web.timer.RetryTaskLogTimerTask;
import com.aizuda.snailjob.server.web.util.UserSessionUtils;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.persistence.dataobject.common.PageQueryDO;
import com.aizuda.snailjob.template.datasource.persistence.dataobject.common.PageResponseDO;
import com.aizuda.snailjob.template.datasource.persistence.dataobject.log.RetryTaskLogMessageDO;
import com.aizuda.snailjob.template.datasource.persistence.dataobject.log.RetryTaskLogMessageQueryDO;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryTaskLogMessageMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryTaskMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.CreateDt;
import com.aizuda.snailjob.template.datasource.persistence.po.CreateUpdateDt;
import com.aizuda.snailjob.template.datasource.persistence.po.Retry;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTaskLogMessage;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RetryTaskServiceImpl
implements RetryTaskService {
    private static final Long DELAY_MILLS = 5000L;
    private final RetryTaskMapper retryTaskMapper;
    private final RetryMapper retryMapper;
    private final RetryTaskLogMessageMapper retryTaskLogMessageMapper;
    private final RetryTaskStopHandler retryTaskStopHandler;
    private final AccessTemplate accessTemplate;
    private final RetryWebService retryWebService;
    private final RetryArgsDeserializeHandler retryArgsDeserializeHandler;

    @Override
    public PageResult<List<RetryTaskResponseVO>> getRetryTaskLogPage(RetryTaskQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        String namespaceId = userSessionVO.getNamespaceId();
        List<String> groupNames = UserSessionUtils.getGroupNames(queryVO.getGroupName());
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryTask::getNamespaceId, (Object)namespaceId)).in(CollUtil.isNotEmpty(groupNames), RetryTask::getGroupName, groupNames)).eq(StrUtil.isNotBlank((CharSequence)queryVO.getSceneName()), RetryTask::getSceneName, (Object)queryVO.getSceneName())).eq(queryVO.getTaskStatus() != null, RetryTask::getTaskStatus, (Object)queryVO.getTaskStatus())).eq(Objects.nonNull(queryVO.getRetryId()), RetryTask::getRetryId, (Object)queryVO.getRetryId())).between(ObjUtil.isNotNull((Object)queryVO.getDatetimeRange()), CreateDt::getCreateDt, (Object)queryVO.getStartDt(), (Object)queryVO.getEndDt())).select(new SFunction[]{RetryTask::getGroupName, RetryTask::getId, RetryTask::getSceneName, RetryTask::getTaskStatus, CreateDt::getCreateDt, CreateUpdateDt::getUpdateDt, RetryTask::getTaskType, RetryTask::getOperationReason, RetryTask::getRetryId}).orderByDesc(CreateDt::getCreateDt);
        PageDTO retryTaskPageDTO = (PageDTO)this.retryTaskMapper.selectPage((IPage)pageDTO, (Wrapper)wrapper);
        return new PageResult<List<RetryTaskResponseVO>>(retryTaskPageDTO, RetryTaskLogResponseVOConverter.INSTANCE.convertList(retryTaskPageDTO.getRecords()));
    }

    @Override
    public void getRetryTaskLogMessagePage(RetryTaskLogMessageQueryVO queryVO) {
        String sid = queryVO.getSid();
        RetryTaskLogMessageQueryDO pageQueryDO = new RetryTaskLogMessageQueryDO();
        pageQueryDO.setPage(1);
        pageQueryDO.setSize(50);
        pageQueryDO.setRetryTaskId(queryVO.getRetryTaskId());
        pageQueryDO.setStartRealTime(queryVO.getStartRealTime());
        pageQueryDO.setSearchCount(true);
        PageResponseDO pageResponseDO = this.accessTemplate.getRetryTaskLogMessageAccess().listPage((PageQueryDO)pageQueryDO);
        long total = pageResponseDO.getTotal();
        int totalPage = (int)((total + (long)queryVO.getSize() - 1L) / (long)queryVO.getSize());
        Long lastRealTime = 0L;
        if (0 == totalPage && null != pageQueryDO.getStartRealTime() && 0L != pageQueryDO.getStartRealTime()) {
            lastRealTime = pageQueryDO.getStartRealTime();
        }
        int i = 1;
        while (i <= totalPage) {
            for (RetryTaskLogMessageDO retryTaskLogMessageDO : pageResponseDO.getRows()) {
                String message = retryTaskLogMessageDO.getMessage();
                List<Map> logContents = (List<Map>)JsonUtil.parseObject((String)message, List.class);
                logContents = logContents.stream().sorted(Comparator.comparingLong(o -> Long.parseLong((String)o.get("time_stamp")))).toList();
                for (Map logContent : logContents) {
                    WsSendEvent sendEvent = new WsSendEvent(this);
                    sendEvent.setSid(sid);
                    sendEvent.setMessage(JsonUtil.toJsonString((Object)logContent));
                    SnailSpringContext.getContext().publishEvent((ApplicationEvent)sendEvent);
                }
            }
            pageQueryDO.setSearchCount(false);
            pageQueryDO.setPage(++i);
            pageResponseDO = this.accessTemplate.getRetryTaskLogMessageAccess().listPage((PageQueryDO)pageQueryDO);
        }
        RetryTask retryTask = (RetryTask)this.retryTaskMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(RetryTask::getId, (Object)queryVO.getRetryTaskId()));
        if (Objects.isNull(retryTask) || RetryTaskStatusEnum.TERMINAL_STATUS_SET.contains(retryTask.getTaskStatus()) && retryTask.getUpdateDt().plusSeconds(15L).isBefore(LocalDateTime.now())) {
            WsSendEvent sendEvent = new WsSendEvent(this);
            sendEvent.setMessage("END");
            sendEvent.setSid(sid);
            SnailSpringContext.getContext().publishEvent((ApplicationEvent)sendEvent);
        } else {
            queryVO.setStartRealTime(lastRealTime);
            this.scheduleNextAttempt(queryVO, sid);
        }
    }

    private void scheduleNextAttempt(RetryTaskLogMessageQueryVO queryVO, String sid) {
        LogTimerWheel.registerWithJobTaskLog(() -> new RetryTaskLogTimerTask(queryVO, sid), Duration.ofMillis(DELAY_MILLS));
    }

    @Override
    public RetryTaskResponseVO getRetryTaskById(Long id) {
        RetryTask retryTask = (RetryTask)this.retryTaskMapper.selectById((Serializable)id);
        if (retryTask == null) {
            return null;
        }
        Retry retry = (Retry)this.retryMapper.selectById((Serializable)retryTask.getRetryId());
        RetryTaskResponseVO responseVO = RetryTaskLogResponseVOConverter.INSTANCE.convert(retryTask);
        RetryResponseWebVO retryResponseWebVO = RetryTaskResponseVOConverter.INSTANCE.convert(retry);
        RetryArgsDeserializeRequest retryArgsDeserializeRequest = new RetryArgsDeserializeRequest();
        retryArgsDeserializeRequest.setArgsStr(retry.getArgsStr());
        retryArgsDeserializeRequest.setExecutorName(retry.getExecutorName());
        retryArgsDeserializeRequest.setScene(retry.getSceneName());
        retryArgsDeserializeRequest.setGroup(retry.getGroupName());
        retryArgsDeserializeRequest.setSerializerName(retry.getSerializerName());
        retryArgsDeserializeRequest.setNamespaceId(retry.getNamespaceId());
        retryResponseWebVO.setArgsStr(this.retryArgsDeserializeHandler.deserialize(retryArgsDeserializeRequest));
        responseVO.setResponseVO(retryResponseWebVO);
        return responseVO;
    }

    @Override
    @Transactional
    public boolean deleteById(Long id) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        RetryTask retryTask = (RetryTask)this.retryTaskMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(RetryTask::getTaskStatus, (Collection)RetryTaskStatusEnum.TERMINAL_STATUS_SET)).eq(RetryTask::getNamespaceId, (Object)namespaceId)).eq(RetryTask::getId, (Object)id));
        Assert.notNull((Object)retryTask, () -> new SnailJobServerException("Data deletion failed"));
        this.retryTaskLogMessageMapper.delete((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryTaskLogMessage::getNamespaceId, (Object)namespaceId)).eq(RetryTaskLogMessage::getGroupName, (Object)retryTask.getGroupName())).eq(RetryTaskLogMessage::getRetryTaskId, (Object)id));
        return 1 == this.retryTaskMapper.deleteById((Serializable)id);
    }

    @Override
    @Transactional
    public boolean batchDelete(Set<Long> ids) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        List retryTasks = this.retryTaskMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(RetryTask::getTaskStatus, (Collection)RetryTaskStatusEnum.TERMINAL_STATUS_SET)).eq(RetryTask::getNamespaceId, (Object)namespaceId)).in(RetryTask::getId, ids));
        Assert.notEmpty((Iterable)retryTasks, () -> new SnailJobServerException("Data does not exist"));
        Assert.isTrue((retryTasks.size() == ids.size() ? 1 : 0) != 0, () -> new SnailJobServerException("Data does not exist"));
        for (RetryTask retryTask : retryTasks) {
            this.retryTaskLogMessageMapper.delete((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryTaskLogMessage::getNamespaceId, (Object)namespaceId)).eq(RetryTaskLogMessage::getGroupName, (Object)retryTask.getGroupName())).eq(RetryTaskLogMessage::getRetryTaskId, (Object)retryTask.getId()));
        }
        return 1 == this.retryTaskMapper.deleteByIds(ids);
    }

    @Override
    public Boolean stopById(Long id) {
        RetryTask retryTask = (RetryTask)this.retryTaskMapper.selectById((Serializable)id);
        Assert.notNull((Object)retryTask, () -> new SnailJobServerException("No executable tasks"));
        Retry retry = (Retry)this.retryMapper.selectById((Serializable)retryTask.getRetryId());
        Assert.notNull((Object)retry, () -> new SnailJobServerException("Task does not exist"));
        TaskStopJobDTO taskStopJobDTO = RetryConverter.INSTANCE.toTaskStopJobDTO(retry);
        taskStopJobDTO.setOperationReason(Integer.valueOf(RetryOperationReasonEnum.MANNER_STOP.getReason()));
        taskStopJobDTO.setNeedUpdateTaskStatus(true);
        taskStopJobDTO.setMessage("User manually triggered stop");
        this.retryTaskStopHandler.stop(taskStopJobDTO);
        return true;
    }

    @Generated
    public RetryTaskServiceImpl(RetryTaskMapper retryTaskMapper, RetryMapper retryMapper, RetryTaskLogMessageMapper retryTaskLogMessageMapper, RetryTaskStopHandler retryTaskStopHandler, AccessTemplate accessTemplate, RetryWebService retryWebService, RetryArgsDeserializeHandler retryArgsDeserializeHandler) {
        this.retryTaskMapper = retryTaskMapper;
        this.retryMapper = retryMapper;
        this.retryTaskLogMessageMapper = retryTaskLogMessageMapper;
        this.retryTaskStopHandler = retryTaskStopHandler;
        this.accessTemplate = accessTemplate;
        this.retryWebService = retryWebService;
        this.retryArgsDeserializeHandler = retryArgsDeserializeHandler;
    }
}

