/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.service.handler;

import cn.hutool.core.collection.CollUtil;
import com.aizuda.snailjob.common.core.constant.SystemConstants;
import com.aizuda.snailjob.model.response.base.WorkflowDetailResponse;
import com.aizuda.snailjob.template.datasource.persistence.mapper.WorkflowNodeMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.graph.MutableGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WorkflowHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowHandler.class);
    private final WorkflowNodeMapper workflowNodeMapper;

    public WorkflowDetailResponse.NodeConfig buildNodeConfig(MutableGraph<Long> graph, Long parentId, Map<Long, WorkflowDetailResponse.NodeConfig> nodeConfigMap, Map<Long, WorkflowDetailResponse.NodeInfo> workflowNodeMap) {
        Set successors = graph.successors((Object)parentId);
        if (CollUtil.isEmpty((Collection)successors)) {
            return null;
        }
        WorkflowDetailResponse.NodeInfo previousNodeInfo = workflowNodeMap.get(parentId);
        WorkflowDetailResponse.NodeConfig currentConfig = new WorkflowDetailResponse.NodeConfig();
        currentConfig.setConditionNodes((List)Lists.newArrayList());
        boolean mount = false;
        for (Long successor : Sets.newTreeSet((Iterable)successors)) {
            Set predecessors = graph.predecessors((Object)successor);
            WorkflowDetailResponse.NodeInfo nodeInfo = workflowNodeMap.get(successor);
            currentConfig.setNodeType(nodeInfo.getNodeType());
            currentConfig.getConditionNodes().add(nodeInfo);
            nodeConfigMap.put(successor, currentConfig);
            if (predecessors.size() >= 2) {
                Object predecessor2;
                HashMap<Long, TreeSet> sets = new HashMap<Long, TreeSet>();
                for (Object predecessor2 : predecessors) {
                    TreeSet set = Sets.newTreeSet();
                    sets.put((Long)predecessor2, set);
                    this.findCommonAncestor((Long)predecessor2, set, graph);
                }
                Set intersection = (Set)sets.values().stream().findFirst().get();
                predecessor2 = sets.values().iterator();
                while (predecessor2.hasNext()) {
                    Set value = (Set)predecessor2.next();
                    intersection = Sets.intersection((Set)value, (Set)intersection);
                }
                Long commonAncestor = (Long)intersection.stream().toList().get(intersection.size() - 1);
                WorkflowDetailResponse.NodeConfig parentNodeConfig = nodeConfigMap.get(Sets.newTreeSet((Iterable)graph.successors((Object)commonAncestor)).stream().findFirst().get());
                parentNodeConfig.setChildNode(currentConfig);
                mount = false;
            } else {
                mount = true;
            }
            this.buildNodeConfig(graph, successor, nodeConfigMap, workflowNodeMap);
        }
        if (!parentId.equals(SystemConstants.ROOT) && mount) {
            previousNodeInfo.setChildNode(currentConfig);
        }
        currentConfig.getConditionNodes().sort(Comparator.comparing(WorkflowDetailResponse.NodeInfo::getPriorityLevel));
        return currentConfig;
    }

    private void findCommonAncestor(Long predecessor, Set<Long> set, MutableGraph<Long> graph) {
        Set predecessors = graph.predecessors((Object)predecessor);
        if (CollUtil.isEmpty((Collection)predecessors)) {
            return;
        }
        set.addAll(predecessors);
        this.findCommonAncestor((Long)new ArrayList(predecessors).get(0), set, graph);
    }

    @Generated
    public WorkflowHandler(WorkflowNodeMapper workflowNodeMapper) {
        this.workflowNodeMapper = workflowNodeMapper;
    }
}

