/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.result.job;

import cn.hutool.core.collection.CollUtil;
import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.enums.JobNotifySceneEnum;
import com.aizuda.snailjob.common.core.enums.JobOperationReasonEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskBatchStatusEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskStatusEnum;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.enums.JobTaskExecutorSceneEnum;
import com.aizuda.snailjob.server.job.task.dto.JobTaskFailAlarmEventDTO;
import com.aizuda.snailjob.server.job.task.dto.WorkflowNodeTaskExecuteDTO;
import com.aizuda.snailjob.server.job.task.support.JobExecutorResultHandler;
import com.aizuda.snailjob.server.job.task.support.JobTaskConverter;
import com.aizuda.snailjob.server.job.task.support.JobTaskStopHandler;
import com.aizuda.snailjob.server.job.task.support.alarm.event.JobTaskFailAlarmEvent;
import com.aizuda.snailjob.server.job.task.support.handler.WorkflowBatchHandler;
import com.aizuda.snailjob.server.job.task.support.result.job.JobExecutorResultContext;
import com.aizuda.snailjob.server.job.task.support.stop.JobTaskStopFactory;
import com.aizuda.snailjob.server.job.task.support.stop.TaskStopJobContext;
import com.aizuda.snailjob.template.datasource.persistence.mapper.GroupConfigMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTask;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTaskBatch;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.context.ApplicationEvent;

public abstract class AbstractJobExecutorResultHandler
implements JobExecutorResultHandler {
    private final JobTaskMapper jobTaskMapper;
    private final JobTaskBatchMapper jobTaskBatchMapper;
    private final WorkflowBatchHandler workflowBatchHandler;
    private final GroupConfigMapper groupConfigMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleResult(JobExecutorResultContext context) {
        int taskBatchStatus;
        List jobTasks = this.jobTaskMapper.selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{JobTask::getTaskStatus, JobTask::getMrStage}).eq(JobTask::getTaskBatchId, (Object)context.getTaskBatchId()));
        if (CollUtil.isEmpty((Collection)jobTasks) || jobTasks.stream().anyMatch(jobTask -> JobTaskStatusEnum.NOT_COMPLETE.contains(jobTask.getTaskStatus()))) {
            return;
        }
        context.setJobTaskList(jobTasks);
        Map<Integer, Long> statusCountMap = jobTasks.stream().collect(Collectors.groupingBy(JobTask::getTaskStatus, Collectors.counting()));
        long failCount = statusCountMap.getOrDefault(JobTaskBatchStatusEnum.FAIL.getStatus(), 0L);
        long stopCount = statusCountMap.getOrDefault(JobTaskBatchStatusEnum.STOP.getStatus(), 0L);
        if (failCount > 0L) {
            taskBatchStatus = JobTaskBatchStatusEnum.FAIL.getStatus();
            SnailSpringContext.getContext().publishEvent((ApplicationEvent)new JobTaskFailAlarmEvent(JobTaskFailAlarmEventDTO.builder().jobTaskBatchId(context.getTaskBatchId()).reason(context.getMessage()).notifyScene(JobNotifySceneEnum.JOB_TASK_ERROR.getNotifyScene()).build()));
            this.doHandleFail(context);
        } else if (stopCount > 0L) {
            taskBatchStatus = JobTaskBatchStatusEnum.STOP.getStatus();
            this.doHandleStop(context);
        } else {
            taskBatchStatus = JobTaskBatchStatusEnum.SUCCESS.getStatus();
            this.doHandleSuccess(context);
        }
        try {
            boolean res = this.updateStatus(context, taskBatchStatus);
            context.setTaskBatchComplete(res);
            if (res) {
                this.stop(context);
            }
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("update job task status failed", new Object[]{e});
        }
        finally {
            this.openNextWorkflowNode(context);
        }
    }

    protected void openNextWorkflowNode(JobExecutorResultContext context) {
        WorkflowNodeTaskExecuteDTO taskExecuteDTO = new WorkflowNodeTaskExecuteDTO();
        taskExecuteDTO.setWorkflowTaskBatchId(context.getWorkflowTaskBatchId());
        taskExecuteDTO.setTaskExecutorScene(JobTaskExecutorSceneEnum.AUTO_WORKFLOW.getType());
        taskExecuteDTO.setParentId(context.getWorkflowNodeId());
        taskExecuteDTO.setTaskBatchId(context.getTaskBatchId());
        this.workflowBatchHandler.openNextNode(taskExecuteDTO);
    }

    protected boolean updateStatus(JobExecutorResultContext context, Integer taskBatchStatus) {
        JobTaskBatch jobTaskBatch = new JobTaskBatch();
        jobTaskBatch.setId(context.getTaskBatchId());
        jobTaskBatch.setTaskBatchStatus(taskBatchStatus);
        jobTaskBatch.setUpdateDt(LocalDateTime.now());
        jobTaskBatch.setOperationReason(Optional.ofNullable(context.getJobOperationReason()).orElse(JobOperationReasonEnum.NONE.getReason()));
        if (JobTaskBatchStatusEnum.NOT_SUCCESS.contains(taskBatchStatus) && context.isRetry()) {
            this.jobTaskBatchMapper.update((Object)jobTaskBatch, (Wrapper)new LambdaUpdateWrapper().eq(JobTaskBatch::getId, (Object)context.getTaskBatchId()));
            return false;
        }
        return 1 == this.jobTaskBatchMapper.update((Object)jobTaskBatch, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(JobTaskBatch::getId, (Object)context.getTaskBatchId())).in(!context.isRetry(), JobTaskBatch::getTaskBatchStatus, (Collection)JobTaskBatchStatusEnum.NOT_COMPLETE));
    }

    protected void stop(JobExecutorResultContext context) {
        JobTaskStopHandler instanceInterrupt = JobTaskStopFactory.getJobTaskStop(this.getTaskInstanceType().getType());
        TaskStopJobContext stopJobContext = JobTaskConverter.INSTANCE.toStopJobContext(context);
        stopJobContext.setNeedUpdateTaskStatus(Boolean.FALSE);
        stopJobContext.setForceStop(Boolean.TRUE);
        instanceInterrupt.stop(stopJobContext);
    }

    protected abstract void doHandleSuccess(JobExecutorResultContext var1);

    protected abstract void doHandleStop(JobExecutorResultContext var1);

    protected abstract void doHandleFail(JobExecutorResultContext var1);

    @Generated
    public AbstractJobExecutorResultHandler(JobTaskMapper jobTaskMapper, JobTaskBatchMapper jobTaskBatchMapper, WorkflowBatchHandler workflowBatchHandler, GroupConfigMapper groupConfigMapper) {
        this.jobTaskMapper = jobTaskMapper;
        this.jobTaskBatchMapper = jobTaskBatchMapper;
        this.workflowBatchHandler = workflowBatchHandler;
        this.groupConfigMapper = groupConfigMapper;
    }
}

