/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.util.graalvm;

import com.agentsflex.core.util.graalvm.JsInteropUtils;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyObject;

public class ProxyMap
implements ProxyObject {
    private final Map<Object, Object> map;
    private final Context context;

    public ProxyMap(Map<Object, Object> map, Context context) {
        this.map = map;
        this.context = context;
    }

    public Object getMember(String key) {
        return JsInteropUtils.wrapJavaValueForJS(this.context, this.map.get(key)).as(Object.class);
    }

    public boolean hasMember(String key) {
        return this.map.containsKey(key);
    }

    public Set<String> getMemberKeys() {
        return this.map.keySet().stream().map(Object::toString).collect(Collectors.toSet());
    }

    public void putMember(String key, Value value) {
        this.map.put(key, JsInteropUtils.unwrapJsValue(value));
    }
}

