/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.prompt;

import com.agentsflex.core.message.HumanImageMessage;
import com.agentsflex.core.message.Message;
import com.agentsflex.core.prompt.TextPrompt;
import com.agentsflex.core.util.ImageUtil;
import com.agentsflex.core.util.StringUtil;
import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;

public class ImagePrompt
extends TextPrompt {
    private String imageUrl;
    private File imageFile;
    private String imageBase64;

    public ImagePrompt(String content) {
        super(content);
    }

    public ImagePrompt(String content, String imageUrl) {
        super(content);
        this.imageUrl = imageUrl;
    }

    public ImagePrompt(String content, File imageFile) {
        super(content);
        this.imageFile = imageFile;
    }

    public ImagePrompt(String content, InputStream imageStream) {
        super(content);
        this.imageBase64 = ImageUtil.imageStreamToBase64(imageStream);
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public void setImageFile(File imageFile) {
        this.imageFile = imageFile;
    }

    public String getImageBase64() {
        return this.imageBase64;
    }

    public void setImageBase64(String imageBase64) {
        this.imageBase64 = imageBase64;
    }

    public String toUrl() {
        if (StringUtil.hasText(this.imageUrl)) {
            return this.imageUrl;
        }
        if (this.imageBase64 != null) {
            return this.imageBase64;
        }
        if (this.imageFile != null) {
            this.imageBase64 = ImageUtil.imageFileToBase64(this.imageFile);
            return this.imageBase64;
        }
        return null;
    }

    public String toImageBase64() {
        if (this.imageBase64 != null) {
            return this.imageBase64;
        }
        if (StringUtil.hasText(this.imageUrl)) {
            this.imageBase64 = ImageUtil.imageUrlToBase64(this.imageUrl);
            return this.imageBase64;
        }
        if (this.imageFile != null) {
            this.imageBase64 = ImageUtil.imageFileToBase64(this.imageFile);
            return this.imageBase64;
        }
        return null;
    }

    @Override
    public List<Message> toMessages() {
        return Collections.singletonList(new HumanImageMessage(this));
    }

    @Override
    public String toString() {
        return "ImagePrompt{imageUrl='" + this.imageUrl + '\'' + ", content='" + this.content + '\'' + ", metadataMap=" + this.metadataMap + '}';
    }
}

