package com.wing321.test.spring.listener;

import com.wing321.annotations.devtime.CreateTable;
import com.wing321.annotations.devtime.StoreData;
import com.wing321.lang.FastDate;
import com.wing321.test.persistence.metadata.ColumnMetadata;
import com.wing321.test.persistence.metadata.TableMetadata;
import com.wing321.test.persistence.utils.EntityUtils;
import com.wing321.test.persistence.utils.PersistenceUtils;
import com.wing321.utils.CsvWriter;
import com.wing321.utils.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;

import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class PersistenceTestExecutionListener extends AbstractTestExecutionListener {
    private static final Log logger = LogFactory.getLog(PersistenceTestExecutionListener.class);
    Class[] entities = null;

    @Override
    public void beforeTestMethod(TestContext ctx) throws Exception {
        final Method testMethod = ctx.getTestMethod();
        final Class<?> testClass = ctx.getTestClass();
        CreateTable createTable = testMethod.getAnnotation(CreateTable.class);
        if (createTable != null) {
            Class[] clazzs = createTable.value();
            entities = clazzs;
            boolean test = createTable.test();
            boolean drop = createTable.drop();
            String db = createTable.db();
            for (Class clazz : clazzs) {
                JdbcTemplate jdbcTemplate = (JdbcTemplate) ctx.getApplicationContext().getBean("jdbcTemplate");
                if (drop) {
                    String dropSql = PersistenceUtils.dropTable(clazz, test);
                    logger.info("this is a auto drop table sql:\n" + dropSql);
                    jdbcTemplate.execute(dropSql);
                }
                String createSql = PersistenceUtils.createTable(clazz, test, db);
                logger.info("this is a auto create table sql:\n" + createSql);
                jdbcTemplate.execute(createSql);
            }
        }
        super.beforeTestMethod(ctx);
    }

    @Override
    public void afterTestMethod(TestContext ctx) throws Exception {
        final Method testMethod = ctx.getTestMethod();
        final Class<?> testClass = ctx.getTestClass();
        StoreData storeData = testMethod.getAnnotation(StoreData.class);
        if (storeData == null || !storeData.enable()) {
            return;
        }
        String[] header = null;
        //遍历创建的实体对应的表
        for (Class clazz : entities) {
            //获取表
            TableMetadata tableMetadata = EntityUtils.extractTable(clazz);
            final Map<String, ColumnMetadata> columns = EntityUtils.extractFields(clazz);
            StringBuilder sql = new StringBuilder("SELECT ");
            int i = 0;
            final int size = columns.size();
            header = new String[size];
            for (String col : columns.keySet()) {
                sql.append(col).append(",");
                header[i] = col;
                i++;
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append(" FROM ").append(tableMetadata.getName());
            JdbcTemplate jdbcTemplate = (JdbcTemplate) ctx.getApplicationContext().getBean("jdbcTemplate");
            List<String[]> list = jdbcTemplate.query(sql.toString(), new RowMapper<String[]>() {
                @Override
                public String[] mapRow(ResultSet resultSet, int i) throws SQLException {
                    String[] datas = new String[size];
                    for (int k = 0; k < columns.size(); k++) {
                        datas[k] = resultSet.getString(k + 1);
                    }
                    return datas;
                }
            });
            if (list.isEmpty()) {
                logger.warn("数据库表未发生持久，放弃存储");
                return;
            }
            File dir = new File("data/" + StringUtils.dotToSlash(testClass.getName()));
            logger.warn("保存数据库数据到文件:" + dir.getCanonicalPath());
            if (!dir.exists()) {
                dir.mkdirs();
            }
            CsvWriter writer = new CsvWriter(new File(dir, testMethod.getName() + new FastDate().toString() + ".csv").getCanonicalPath());
            writer.writeRecord(header);
            for (String[] datas : list) {
                writer.writeRecord(datas);
            }
            writer.close();
        }
        super.afterTestMethod(ctx);
    }
}
