package com.wing321.test.persistence.utils;


import com.wing321.test.persistence.metadata.ColumnMetadata;
import com.wing321.test.persistence.metadata.TableMetadata;

import java.util.List;
import java.util.Map;

public abstract class PersistenceUtils {
    /**
     * 截断表
     * @param clazz
     * @return
     */
    public static String truncateTable(Class clazz){
        if(clazz == null){
            throw new NullPointerException("clazz is null");
        }
        TableMetadata tableMetadata = EntityUtils.extractTable(clazz);
        return "TRUNCATE TABLE " + tableMetadata.getName();
    }

    /**
     * 删除表
     * @param clazz
     * @return
     */
    public static String dropTable(Class clazz, boolean test){
        if(clazz == null){
            throw new NullPointerException("clazz is null");
        }
        StringBuilder sql = new StringBuilder("DROP TABLE");
        TableMetadata tableMetadata = EntityUtils.extractTable(clazz);
        if(test){
            sql.append(" IF EXISTS");
        }
        sql.append(" " + tableMetadata.getName());
        return sql.toString();
    }
    /**
     * 创建表
     * @param clazz 实体类对象
     * @param test 是否进行测试
     * @param db 数据库类型
     * @return
     */
    public static String createTable(Class clazz, boolean test, String db) {
        if(clazz == null){
            throw new NullPointerException("clazz is null");
        }
        List<String> pks = EntityUtils.extractPrimaryKey(clazz);
        if(pks.isEmpty()){
            throw new IllegalArgumentException(clazz + "不允许无物理主键的表");
        }
        Map<String, ColumnMetadata> fields = EntityUtils.extractFields(clazz);
        TableMetadata tableMetadata = EntityUtils.extractTable(clazz);
        StringBuilder sql = new StringBuilder("CREATE TABLE");
        if(test){
            sql.append(" IF NOT EXISTS");
        }
        sql.append(" " + tableMetadata.getName());
        sql.append("(\n");
        int index = 0;
        for (String name : fields.keySet()) {
            index++;
            ColumnMetadata columnMetadata = fields.get(name);
            //字段名 数据类型
            sql.append(" ").append(name).append(" ").append(columnMetadata.getDataType());
            if(columnMetadata.isNullable()){
                sql.append(" NULL ");
                if(columnMetadata.getJdbcType().equals("TIMESTAMP")){
                    sql.append(" DEFAULT '0000-00-00 00:00:00' ");
                }
                if(columnMetadata.getDataType().startsWith("DECIMAL") || columnMetadata.getDataType().startsWith("NUMERIC")){
                    sql.append(" DEFAULT 0 ");
                }
                if(columnMetadata.getJdbcType().equals("VARCHAR")){
                    sql.append(" DEFAULT '' ");
                }
            }else{
                sql.append(" NOT NULL ");
            }
            if(columnMetadata.isAutoKey()){
                sql.append(" AUTO_INCREMENT ");
            }
            if (!columnMetadata.getComment().trim().isEmpty()) {
                sql.append(" COMMENT '").append(columnMetadata.getComment()).append("'");
            }
            sql.append(",\n");
        }
        sql.append(primaryKey(pks) + "\n");
        sql.append(") ");
        //如果实体类上有注解
        if (!tableMetadata.getComment().isEmpty()) {
            sql.append("COMMENT = '" + tableMetadata.getComment() + "'");
        }
        return sql.toString();
    }

    static String primaryKey(List<String> pks) {
        String primaryKey = " PRIMARY KEY(";
        for (int i = 0; i < pks.size(); i++) {
            if (i == 0) {
                primaryKey = primaryKey + pks.get(i);
            } else {
                primaryKey = primaryKey + "," + pks.get(i);
            }
        }
        primaryKey = primaryKey + ")";
        return primaryKey;
    }

}
