package com.wing321.test.persistence.metadata;

public class ColumnMetadata {
    String name;
    String jdbcName;
    String dataType;
    String jdbcType;
    boolean nullable;
    String comment;
    boolean autoKey;

    public ColumnMetadata(String name, String jdbcName, String dataType, String jdbcType, boolean nullable, String comment) {
        this.name = name;
        this.jdbcName = jdbcName;
        this.dataType = dataType;
        this.jdbcType = jdbcType;
        this.nullable = nullable;
        this.comment = comment;
    }

    public ColumnMetadata(String name, String jdbcName, String dataType, String jdbcType, boolean nullable, String comment, boolean autoKey) {
        this.name = name;
        this.jdbcName = jdbcName;
        this.dataType = dataType;
        this.jdbcType = jdbcType;
        this.nullable = nullable;
        this.comment = comment;
        this.autoKey = autoKey;
    }

    public boolean isNullable() {
        return nullable;
    }

    public String getDataType() {
        return dataType;
    }

    public String getName() {
        return name;
    }

    public String getJdbcName() {
        return jdbcName;
    }

    public String getComment() {
        return comment;
    }

    public String getJdbcType() {
        return jdbcType;
    }

    public boolean isAutoKey() {
        return autoKey;
    }
}