package com.wing321.test;

import org.junit.runner.RunWith;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.support.DirtiesContextTestExecutionListener;
import org.springframework.test.context.web.ServletTestExecutionListener;
import org.springframework.util.Assert;

/**
 * 测试基类
 * @ContextConfiguration(locations = {"classpath*:testContext-demo.xml"})
 * @author woate
 */
@RunWith(SpringJUnit4ClassRunner.class)
@TestExecutionListeners({
        ServletTestExecutionListener.class,
        DirtiesContextTestExecutionListener.class,
        DependencyInjectionTestExecutionListener.class})
public abstract class BaseTest implements ApplicationContextAware {

    /**
     * 按照Bean名称获取实例
     *
     * @param name bean名称
     * @param <T>
     * @return 实例
     */
    public <T> T getBean(String name) {
        Assert.notNull(name);
        T bean = (T) this.applicationContext.getBean(name);
        Assert.notNull(bean);
        return bean;
    }

    /**
     * 按照Bean 接口获取实例
     * @param clazz Bean接口
     * @param <T>
     * @return 实例
     */
    public <T> T getBean(Class<T> clazz) {
        Assert.notNull(clazz);
        T bean = (T) this.applicationContext.getBean(clazz);
        Assert.notNull(bean);
        return bean;
    }

    protected ApplicationContext applicationContext;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
