package com.wing321.annotations.runtime.persistence;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * 该注解用于标记实体类生成SQL语句时的备注语句
 * @author wing321
 */
@Target({TYPE, FIELD})
@Retention(RUNTIME)
public @interface Comment {
    /**
     * 表的备注
     * @return 备注
     */
    String value();
}
