package com.wing321.annotations.devtime;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 测试顺序，用于对标注的测试方法进行排序
 * @author wing321
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface TestOrder {
    /**
     * 用于指定执行的序号，从1开始递增，允许相同，但是如果相同，则使用方法名进行字典排序
     * @return 执行的序号
     */
    int value();
}
