package com.wing321.annotations.devtime;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 该注解用于标记当前测试方法是否保存单元测试时产生的数据
 * @author wing321
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface StoreData {
    /**
     * 是否激活数据保存，如果为假，与不加注解同一个效果
     * @return
     */
    boolean enable() default false;
    /**
     * 保存的测试数据是否采用时间戳作为文件名保存
     * @return
     */
    boolean useTimestampe() default true;
}
