package com.wing321.annotations.devtime;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 用于开发时进行单元测试自动创建表结构
 * @author wing321
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface CreateTable {
    /**
     * 需要创建表结构的实体类
     * @return 实体类列表
     */
    Class[] value();

    /**
     * 生成何种数据库的建表语句
     * @return
     */
    String db() default "h2";
    /**
     * 创建表时是否进行测试
     * @return 如果如果为真，当表存在则不创建表结构，不存在则创建
     */
    boolean test()default true;

    /**
     * 是否每次进行单元测试时进行表结构删除
     * @return 如果如果为真，则执行删除表结构语句，否则不执行删除表结构
     */
    boolean drop() default true;
}
