/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class RepositoryStatsShards
implements JsonpSerializable {
    private final int total;
    private final int complete;
    private final int incomplete;
    private final Map<String, Integer> states;
    public static final JsonpDeserializer<RepositoryStatsShards> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RepositoryStatsShards::setupRepositoryStatsShardsDeserializer);

    private RepositoryStatsShards(Builder builder) {
        this.total = ApiTypeHelper.requireNonNull(builder.total, (Object)this, "total", 0);
        this.complete = ApiTypeHelper.requireNonNull(builder.complete, (Object)this, "complete", 0);
        this.incomplete = ApiTypeHelper.requireNonNull(builder.incomplete, (Object)this, "incomplete", 0);
        this.states = ApiTypeHelper.unmodifiableRequired(builder.states, (Object)this, "states");
    }

    public static RepositoryStatsShards of(Function<Builder, ObjectBuilder<RepositoryStatsShards>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int total() {
        return this.total;
    }

    public final int complete() {
        return this.complete;
    }

    public final int incomplete() {
        return this.incomplete;
    }

    public final Map<String, Integer> states() {
        return this.states;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("total");
        generator.write(this.total);
        generator.writeKey("complete");
        generator.write(this.complete);
        generator.writeKey("incomplete");
        generator.write(this.incomplete);
        if (ApiTypeHelper.isDefined(this.states)) {
            generator.writeKey("states");
            generator.writeStartObject();
            for (Map.Entry<String, Integer> item0 : this.states.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue().intValue());
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRepositoryStatsShardsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::total, JsonpDeserializer.integerDeserializer(), "total");
        op.add(Builder::complete, JsonpDeserializer.integerDeserializer(), "complete");
        op.add(Builder::incomplete, JsonpDeserializer.integerDeserializer(), "incomplete");
        op.add(Builder::states, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.integerDeserializer()), "states");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RepositoryStatsShards> {
        private Integer total;
        private Integer complete;
        private Integer incomplete;
        private Map<String, Integer> states;

        public final Builder total(int value) {
            this.total = value;
            return this;
        }

        public final Builder complete(int value) {
            this.complete = value;
            return this;
        }

        public final Builder incomplete(int value) {
            this.incomplete = value;
            return this;
        }

        public final Builder states(Map<String, Integer> map) {
            this.states = Builder._mapPutAll(this.states, map);
            return this;
        }

        public final Builder states(String key, Integer value) {
            this.states = Builder._mapPut(this.states, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RepositoryStatsShards build() {
            this._checkSingleUse();
            return new RepositoryStatsShards(this);
        }
    }
}

