/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v3.sourcegen;

import ca.uhn.hl7v3.sourcegen.AttributeDefinition;
import ca.uhn.hl7v3.sourcegen.ClassDefinition;
import ca.uhn.hl7v3.sourcegen.ComponentDefinition;
import ca.uhn.hl7v3.sourcegen.DataTypeDefinition;
import ca.uhn.hl7v3.sourcegen.DataTypeGenerator;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class DefinitionLoader {
    Connection conn;

    public DefinitionLoader(Connection conn) {
        this.conn = conn;
    }

    public String[] getRIMClassNames() throws SQLException {
        return this.getList("className", "RIM_class", null);
    }

    public String[] getRIMDataTypeNames() throws SQLException {
        return this.getList("datatype", "DT_datatypes", "where (datatypeKind = 'Composite' or datatypeKind = 'Generic' or datatypeKind = 'Primitive' or datatypeKind = 'Instance')");
    }

    private String[] getList(String field, String table, String where) throws SQLException {
        String[] items = null;
        Statement stmt = this.conn.createStatement();
        StringBuffer sql = new StringBuffer();
        sql.append("select ");
        sql.append(field);
        sql.append(" from ");
        sql.append(table);
        sql.append(" ");
        if (where != null) {
            sql.append(where);
        }
        ResultSet rs = stmt.executeQuery(sql.toString());
        ArrayList<String> tmpList = new ArrayList<String>(150);
        while (rs.next()) {
            tmpList.add(rs.getString(field));
        }
        items = new String[tmpList.size()];
        int i = 0;
        while (i < items.length) {
            items[i] = (String)tmpList.get(i);
            ++i;
        }
        return items;
    }

    public ClassDefinition getRIMClassDef(String className) throws SQLException {
        ClassDefinition def = new ClassDefinition();
        StringBuffer sql = new StringBuffer();
        sql.append("select description, isAbstractClass from RIM_class where className = '");
        sql.append(className);
        sql.append("'");
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery(sql.toString());
        if (!rs.next()) {
            stmt.close();
            throw new SQLException("RIM class " + className + " not found in database");
        }
        def.setName(className);
        def.setDescription(rs.getString("description"));
        def.setIsAbstract(rs.getBoolean("isAbstractClass"));
        def.setSuperClass(this.getRIMSuperClass(className));
        def.setAttributes(this.getRIMAttributes(className));
        return def;
    }

    public AttributeDefinition[] getRIMAttributes(String className) throws SQLException {
        AttributeDefinition[] defs = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select attName from RIM_attribute where className = '");
        sql.append(className);
        sql.append("'");
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery(sql.toString());
        ArrayList<String> attNames = new ArrayList<String>(20);
        while (rs.next()) {
            attNames.add(rs.getString("attName"));
        }
        stmt.close();
        defs = new AttributeDefinition[attNames.size()];
        int i = 0;
        while (i < defs.length) {
            defs[i] = this.getRIMAttributeDef(className, (String)attNames.get(i));
            ++i;
        }
        return defs;
    }

    public AttributeDefinition getRIMAttributeDef(String className, String attributeName) throws SQLException {
        AttributeDefinition def = new AttributeDefinition();
        StringBuffer sql = new StringBuffer();
        sql.append("select attDatatype, description from RIM_attribute where className = '");
        sql.append(className);
        sql.append("' and attName = '");
        sql.append(attributeName);
        sql.append("'");
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery(sql.toString());
        if (!rs.next()) {
            stmt.close();
            throw new SQLException("Attribute " + attributeName + " of RIM class " + className + " not found in database");
        }
        def.setDataType(rs.getString("attDatatype"));
        def.setName(attributeName);
        def.setDescription(rs.getString("description"));
        stmt.close();
        return def;
    }

    public String getRIMSuperClass(String className) throws SQLException {
        String superClass = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select sourceClassName from RIM_relationship where destClassName = '");
        sql.append(className);
        sql.append("' and relnName = 'generalizes'");
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery(sql.toString());
        if (rs.next()) {
            superClass = rs.getString("sourceClassName");
        }
        stmt.close();
        return superClass;
    }

    public DataTypeDefinition getDataTypeDef(String className) throws SQLException {
        DataTypeDefinition def = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select datatypeName, description, datatypeKind from DT_datatypes where datatype = '");
        sql.append(className);
        sql.append("'");
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery(sql.toString());
        if (rs.next()) {
            def = new DataTypeDefinition();
            def.setName(className);
            def.setLongName(rs.getString("datatypeName"));
            def.setDescription(rs.getString("description"));
            def.setType(rs.getString("datatypeKind"));
            if (def.getType().equalsIgnoreCase("Composite")) {
                def.setComponents(this.getComponentDefs(className));
            }
            def.setSuperClass(this.getDTSuperClass(className));
        }
        stmt.close();
        return def;
    }

    public ComponentDefinition[] getComponentDefs(String className) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select componentName, componentDT, description from DT_component where parentDT = '");
        sql.append(className);
        sql.append("'");
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery(sql.toString());
        ArrayList<ComponentDefinition> list = new ArrayList<ComponentDefinition>();
        while (rs.next()) {
            ComponentDefinition def = new ComponentDefinition();
            def.setName(rs.getString("componentName"));
            def.setDataType(rs.getString("componentDT"));
            def.setDescription(rs.getString("description"));
            list.add(def);
        }
        ComponentDefinition[] defs = new ComponentDefinition[list.size()];
        int i = 0;
        while (i < defs.length) {
            defs[i] = (ComponentDefinition)list.get(i);
            ++i;
        }
        return defs;
    }

    public String getDTSuperClass(String dataType) throws SQLException {
        String superClass = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select superDT from DT_generalization where subDT = '");
        sql.append(dataType);
        sql.append("'");
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery(sql.toString());
        if (rs.next()) {
            superClass = rs.getString("superDT");
        }
        stmt.close();
        return superClass;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: DefinitionLoader RIM_class");
            System.exit(1);
        }
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            Connection conn = DriverManager.getConnection("jdbc:odbc:RIM");
            DefinitionLoader dl = new DefinitionLoader(conn);
            DataTypeDefinition def = dl.getDataTypeDef(args[0]);
            DataTypeGenerator gen = new DataTypeGenerator();
            System.out.println(gen.makeDataType(def));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

