/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.impl;

import ca.uhn.hl7v2.validation.EncodingRule;
import ca.uhn.hl7v2.validation.ValidationException;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLSchemaRule
implements EncodingRule {
    private static final HapiLog log = HapiLogFactory.getHapiLog(XMLSchemaRule.class);
    private static final String parserName = "org.apache.xerces.parsers.SAXParser";
    private XMLGrammarPool myGrammarPool = new XMLGrammarPoolImpl();
    private Element myNamespaceNode;
    private DocumentBuilder myBuilder = this.createDocumentBuilder();

    public XMLSchemaRule() {
        this.myNamespaceNode = this.createNamespaceNode(this.myBuilder);
    }

    public ValidationException[] test(String msg) {
        ArrayList<ValidationException> validationErrors = new ArrayList<ValidationException>(20);
        Document domDocumentToValidate = null;
        StringReader stringReaderForDom = new StringReader(msg);
        try {
            String schemaLocation;
            domDocumentToValidate = this.myBuilder.parse(new InputSource(stringReaderForDom));
            if (this.validateNamespace(domDocumentToValidate, validationErrors) && (schemaLocation = this.getSchemaLocation(domDocumentToValidate, validationErrors)).length() > 0) {
                XMLReader parser = XMLReaderFactory.createXMLReader(parserName);
                SchemaEventHandler eventHandler = new SchemaEventHandler(validationErrors);
                parser.setContentHandler(eventHandler);
                parser.setErrorHandler(eventHandler);
                parser.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", "urn:hl7-org:v2xml " + schemaLocation);
                parser.setFeature("http://xml.org/sax/features/validation", true);
                parser.setFeature("http://apache.org/xml/features/validation/schema", true);
                parser.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
                parser.setProperty("http://apache.org/xml/properties/internal/grammar-pool", this.myGrammarPool);
                StringReader stringReaderForSax = new StringReader(msg);
                parser.parse(new InputSource(stringReaderForSax));
            }
        }
        catch (SAXException se) {
            log.error("Unable to parse message - please verify that it's a valid xml document");
            log.error("SAXException: ", se);
            validationErrors.add(new ValidationException("Unable to parse message - please verify that it's a valid xml document [SAXException] " + se.getMessage()));
        }
        catch (IOException e) {
            log.error("Unable to parse message - please verify that it's a valid xml document");
            log.error("IOException: ", e);
            validationErrors.add(new ValidationException("Unable to parse message - please verify that it's a valid xml document [IOException] " + e.getMessage()));
        }
        return validationErrors.toArray(new ValidationException[0]);
    }

    private Element createNamespaceNode(DocumentBuilder theBuilder) {
        Element namespaceNode = null;
        if (theBuilder != null) {
            DOMImplementation impl = theBuilder.getDOMImplementation();
            Document namespaceHolder = impl.createDocument("http://namespaceuri.org", "f:namespaceMapping", null);
            namespaceNode = namespaceHolder.getDocumentElement();
            namespaceNode.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:hl7v2xml", "urn:hl7-org:v2xml");
            namespaceNode.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
        return namespaceNode;
    }

    private DocumentBuilder createDocumentBuilder() {
        DocumentBuilder builder = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            try {
                builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                log.error(e.getMessage());
            }
        }
        catch (FactoryConfigurationError e) {
            log.error(e.getMessage());
        }
        return builder;
    }

    private String getSchemaLocation(Document domDocumentToValidate, List validationErrors) {
        boolean validSchemaInDocument = false;
        String schemaLocation = new String();
        String schemaFilename = new String();
        try {
            log.debug("Trying to retrieve the schema defined in the xml document");
            Node schemaNode = XPathAPI.selectSingleNode((Node)domDocumentToValidate, (String)"//@xsi:schemaLocation", (Node)this.myNamespaceNode);
            if (schemaNode != null) {
                log.debug("Schema defined in document: " + schemaNode.getNodeValue());
                String[] schemaItems = schemaNode.getNodeValue().split(" ");
                if (schemaItems.length == 2) {
                    File myFile = new File(schemaItems[1].toString());
                    if (myFile.exists()) {
                        validSchemaInDocument = true;
                        schemaFilename = schemaItems[1].toString();
                        log.debug("Schema defined in document points to a valid file - use this one");
                    } else {
                        log.warn("Schema file defined in xml document not found on disk: " + schemaItems[1].toString());
                    }
                }
            } else {
                log.debug("No schema defined in the xml document");
            }
            if (!validSchemaInDocument) {
                log.debug("Lookup hl7 version in msh-12 to know which default schema to use");
                Node versionNode = XPathAPI.selectSingleNode((Node)domDocumentToValidate, (String)"//hl7v2xml:MSH.12/hl7v2xml:VID.1/text()", (Node)this.myNamespaceNode);
                if (versionNode != null) {
                    File myFile;
                    String schemaLocationProperty = String.valueOf(new String("ca.uhn.hl7v2.validation.xmlschemavalidator.schemalocation.")) + versionNode.getNodeValue();
                    log.debug("Lookup schema location system property: " + schemaLocationProperty);
                    schemaLocation = System.getProperty(schemaLocationProperty);
                    if (schemaLocation == null) {
                        log.warn("System property for schema location path " + schemaLocationProperty + " not defined");
                        schemaLocation = String.valueOf(System.getProperty("user.dir")) + "\\v" + versionNode.getNodeValue().replaceAll("\\.", "") + "\\xsd";
                        log.info("Using default schema location path (current directory\\v2x\\xsd) " + schemaLocation);
                    }
                    if ((myFile = new File(schemaFilename = String.valueOf(schemaLocation) + "/" + domDocumentToValidate.getDocumentElement().getNodeName() + ".xsd")).exists()) {
                        validSchemaInDocument = true;
                        log.debug("Valid schema file present: " + schemaFilename);
                    } else {
                        log.warn("Schema file not found on disk: " + schemaFilename);
                    }
                } else {
                    log.error("HL7 version node MSH-12 not present - unable to determine default schema");
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        if (validSchemaInDocument) {
            return schemaFilename;
        }
        ValidationException e = new ValidationException("Unable to retrieve a valid schema to use for message validation - please check logs");
        validationErrors.add(e);
        return "";
    }

    private boolean validateNamespace(Document domDocumentToValidate, List validationErrors) {
        if (domDocumentToValidate.getDocumentElement().getNamespaceURI() == null) {
            ValidationException e = new ValidationException("The default namespace of the xml document is not specified - should be urn:hl7-org:v2xml");
            validationErrors.add(e);
            log.error("The default namespace of the xml document is not specified - should be urn:hl7-org:v2xml");
        } else if (!domDocumentToValidate.getDocumentElement().getNamespaceURI().equals("urn:hl7-org:v2xml")) {
            ValidationException e = new ValidationException("The default namespace of the xml document (" + domDocumentToValidate.getDocumentElement().getNamespaceURI() + ") is incorrect - should be urn:hl7-org:v2xml");
            validationErrors.add(e);
            log.error("The default namespace of the xml document (" + domDocumentToValidate.getDocumentElement().getNamespaceURI() + ") is incorrect - should be urn:hl7-org:v2xml");
        } else {
            return true;
        }
        return false;
    }

    public String getDescription() {
        return "Checks that an encoded XML message validates against a declared or default schema (it is recommended to use the standard HL7 schema, but this is not enforced here).";
    }

    public String getSectionReference() {
        return "http://www.hl7.org/Special/committees/xml/drafts/v2xml.html";
    }

    private class SchemaEventHandler
    extends DefaultHandler {
        private List validationErrors;

        public SchemaEventHandler(List theValidationErrorList) {
            this.validationErrors = theValidationErrorList;
        }

        public void warning(SAXParseException ex) {
            this.validationErrors.add(new ValidationException("[Warning] " + this.getLocationString(ex) + ": " + ex.getMessage() + " "));
        }

        public void error(SAXParseException ex) {
            this.validationErrors.add(new ValidationException("[Error] " + this.getLocationString(ex) + ": " + ex.getMessage() + " "));
        }

        public void fatalError(SAXParseException ex) throws SAXException {
            this.validationErrors.add(new ValidationException("[Fatal Error] " + this.getLocationString(ex) + ": " + ex.getMessage() + " "));
        }

        private String getLocationString(SAXParseException ex) {
            StringBuffer str = new StringBuffer();
            String systemId = ex.getSystemId();
            if (systemId != null) {
                int index = systemId.lastIndexOf(47);
                if (index != -1) {
                    systemId = systemId.substring(index + 1);
                }
                str.append(systemId);
            }
            str.append(':');
            str.append(ex.getLineNumber());
            str.append(':');
            str.append(ex.getColumnNumber());
            return str.toString();
        }
    }
}

