/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.parser;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.parser.XMLParser;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultXMLParser
extends XMLParser {
    private static final HapiLog log = HapiLogFactory.getHapiLog(DefaultXMLParser.class);
    private static final Set<String> ourForceGroupNames = new HashSet<String>();

    static {
        ourForceGroupNames.add("DIET");
    }

    public DefaultXMLParser() {
    }

    public DefaultXMLParser(ModelClassFactory theFactory) {
        super(theFactory);
    }

    public Document encodeDocument(Message source) throws HL7Exception {
        String messageClassName = source.getClass().getName();
        String messageName = messageClassName.substring(messageClassName.lastIndexOf(46) + 1);
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = doc.createElement(messageName);
            doc.appendChild(root);
        }
        catch (Exception e) {
            throw new HL7Exception("Can't create XML document - " + e.getClass().getName(), 207, e);
        }
        this.encode((Group)source, doc.getDocumentElement());
        return doc;
    }

    private void encode(Group groupObject, Element groupElement) throws HL7Exception {
        String[] childNames = groupObject.getNames();
        String messageName = groupObject.getMessage().getName();
        try {
            int i = 0;
            while (i < childNames.length) {
                Structure[] reps = groupObject.getAll(childNames[i]);
                int j = 0;
                while (j < reps.length) {
                    Element childElement = groupElement.getOwnerDocument().createElement(DefaultXMLParser.makeGroupElementName(messageName, childNames[i]));
                    groupElement.appendChild(childElement);
                    if (reps[j] instanceof Group) {
                        this.encode((Group)reps[j], childElement);
                    } else if (reps[j] instanceof Segment) {
                        this.encode((Segment)reps[j], childElement);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (DOMException e) {
            throw new HL7Exception("Can't encode group " + groupObject.getClass().getName(), 207, e);
        }
    }

    public Message parseDocument(Document XMLMessage, String version) throws HL7Exception {
        String messageName = XMLMessage.getDocumentElement().getTagName();
        Message message = this.instantiateMessage(messageName, version, true);
        this.parse((Group)message, XMLMessage.getDocumentElement());
        return message;
    }

    private void parse(Group groupObject, Element groupElement) throws HL7Exception {
        String[] childNames = groupObject.getNames();
        String messageName = groupObject.getMessage().getName();
        NodeList allChildNodes = groupElement.getChildNodes();
        ArrayList<String> unparsedElementList = new ArrayList<String>();
        int i = 0;
        while (i < allChildNodes.getLength()) {
            Node node = allChildNodes.item(i);
            String name = node.getNodeName();
            if (node.getNodeType() == 1 && !unparsedElementList.contains(name)) {
                unparsedElementList.add(name);
            }
            ++i;
        }
        i = 0;
        while (i < childNames.length) {
            unparsedElementList.remove(childNames[i]);
            if (childNames[i].length() != 4) {
                this.parseReps(groupElement, groupObject, messageName, childNames[i], childNames[i]);
            } else {
                log.debug("Skipping rep segment: " + childNames[i]);
            }
            ++i;
        }
        i = 0;
        while (i < unparsedElementList.size()) {
            String segName = (String)unparsedElementList.get(i);
            String segIndexName = groupObject.addNonstandardSegment(segName);
            this.parseReps(groupElement, groupObject, messageName, segName, segIndexName);
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseReps(Element groupElement, Group groupObject, String messageName, String childName, String childIndexName) throws HL7Exception {
        block9: {
            reps = this.getChildElementsByTagName(groupElement, DefaultXMLParser.makeGroupElementName(messageName, childName));
            DefaultXMLParser.log.debug("# of elements matching " + DefaultXMLParser.makeGroupElementName(messageName, childName) + ": " + reps.size());
            if (groupObject.isRepeating(childIndexName)) {
                i = 0;
                while (i < reps.size()) {
                    this.parseRep((Element)reps.get(i), groupObject.get(childIndexName, i));
                    ++i;
                }
            } else {
                if (reps.size() > 0) {
                    this.parseRep((Element)reps.get(0), groupObject.get(childIndexName, 0));
                }
                if (reps.size() > 1) {
                    newIndexName = "";
                    i = 1;
                    try {
                        i = 1;
                        while (i < reps.size()) {
                            newIndexName = String.valueOf(childName) + (i + 1);
                            st = groupObject.get(newIndexName);
                            this.parseRep((Element)reps.get(i), st);
                            ++i;
                        }
                        break block9;
                    }
                    catch (Throwable t) {
                        DefaultXMLParser.log.info("Issue Parsing: " + t);
                        newIndexName = groupObject.addNonstandardSegment(childName);
                        j = i;
                        ** while (j < reps.size())
                    }
lbl-1000:
                    // 1 sources

                    {
                        this.parseRep((Element)reps.get(j), groupObject.get(newIndexName, j - i));
                        ++j;
                        continue;
lbl32:
                        // 1 sources

                        break;
                    }
                }
            }
        }
    }

    private void parseRep(Element theElem, Structure theObj) throws HL7Exception {
        if (theObj instanceof Group) {
            this.parse((Group)theObj, theElem);
        } else if (theObj instanceof Segment) {
            this.parse((Segment)theObj, theElem);
        }
        log.debug("Parsed element: " + theElem.getNodeName());
    }

    private List getChildElementsByTagName(Element theElement, String theName) {
        ArrayList<Node> result = new ArrayList<Node>(10);
        NodeList children = theElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equals(theName)) {
                result.add(child);
            }
            ++i;
        }
        return result;
    }

    protected static String makeGroupElementName(String messageName, String className) {
        String ret = null;
        if (className.length() > 4 || ourForceGroupNames.contains(className)) {
            StringBuilder elementName = new StringBuilder();
            elementName.append(messageName);
            elementName.append('.');
            elementName.append(className);
            ret = elementName.toString();
        } else {
            ret = className.length() == 4 ? className.substring(0, 3) : className;
        }
        return ret;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: DefaultXMLParser pipe_encoded_file");
            System.exit(1);
        }
        try {
            File messageFile = new File(args[0]);
            long fileLength = messageFile.length();
            FileReader r = new FileReader(messageFile);
            char[] cbuf = new char[(int)fileLength];
            System.out.println("Reading message file ... " + r.read(cbuf) + " of " + fileLength + " chars");
            r.close();
            String messString = String.valueOf(cbuf);
            Parser inParser = null;
            Parser outParser = null;
            PipeParser pp = new PipeParser();
            DefaultXMLParser xp = new DefaultXMLParser();
            System.out.println("Encoding: " + pp.getEncoding(messString));
            if (pp.getEncoding(messString) != null) {
                inParser = pp;
                outParser = xp;
            } else if (xp.getEncoding(messString) != null) {
                inParser = xp;
                outParser = pp;
            }
            Message mess = ((Parser)inParser).parse(messString);
            System.out.println("Got message of type " + mess.getClass().getName());
            String otherEncoding = outParser.encode(mess);
            System.out.println(otherEncoding);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

