/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.parser;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.GenericMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModelClassFactory
implements ModelClassFactory {
    private static final long serialVersionUID = 1L;
    private static final HapiLog log = HapiLogFactory.getHapiLog(DefaultModelClassFactory.class);
    private static final String CUSTOM_PACKAGES_RESOURCE_NAME_TEMPLATE = "custom_packages/{0}";
    private static final HashMap<String, String[]> packages = new HashMap();
    private static List<String> ourVersions = null;

    static {
        DefaultModelClassFactory.reloadPackages();
    }

    @Override
    public Class<? extends Message> getMessageClass(String theName, String theVersion, boolean isExplicit) throws HL7Exception {
        Class mc = null;
        if (!isExplicit) {
            theName = Parser.getMessageStructureForEvent(theName, theVersion);
        }
        if ((mc = DefaultModelClassFactory.findClass(theName, theVersion, "message")) == null) {
            mc = GenericMessage.getGenericMessageClass(theVersion);
        }
        return mc;
    }

    @Override
    public Class<? extends Group> getGroupClass(String theName, String theVersion) throws HL7Exception {
        return DefaultModelClassFactory.findClass(theName, theVersion, "group");
    }

    @Override
    public Class<? extends Segment> getSegmentClass(String theName, String theVersion) throws HL7Exception {
        return DefaultModelClassFactory.findClass(theName, theVersion, "segment");
    }

    @Override
    public Class<? extends Type> getTypeClass(String theName, String theVersion) throws HL7Exception {
        return DefaultModelClassFactory.findClass(theName, theVersion, "datatype");
    }

    public static String getVersionPackagePath(String ver) throws HL7Exception {
        if (!Parser.validVersion(ver)) {
            throw new HL7Exception("The HL7 version " + ver + " is not recognized", 203);
        }
        StringBuffer path = new StringBuffer("ca/uhn/hl7v2/model/v");
        char[] versionChars = new char[ver.length()];
        ver.getChars(0, ver.length(), versionChars, 0);
        int i = 0;
        while (i < versionChars.length) {
            if (versionChars[i] != '.') {
                path.append(versionChars[i]);
            }
            ++i;
        }
        path.append('/');
        return path.toString();
    }

    public static String getVersionPackageName(String ver) throws HL7Exception {
        String path = DefaultModelClassFactory.getVersionPackagePath(ver);
        String packg = path.replace('/', '.');
        packg = packg.replace('\\', '.');
        return packg;
    }

    public static String[] packageList(String version) throws HL7Exception {
        return packages.get(version);
    }

    private static String[] loadPackages(String version) throws HL7Exception {
        String[] retVal = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String customPackagesResourceName = MessageFormat.format(CUSTOM_PACKAGES_RESOURCE_NAME_TEMPLATE, version);
        InputStream resourceInputStream = classLoader.getResourceAsStream(customPackagesResourceName);
        ArrayList<String> packageList = new ArrayList<String>();
        if (resourceInputStream != null) {
            BufferedReader in = new BufferedReader(new InputStreamReader(resourceInputStream));
            try {
                String line = in.readLine();
                while (line != null) {
                    log.info("Adding package to user-defined package list: " + line);
                    packageList.add(line);
                    line = in.readLine();
                }
            }
            catch (IOException e) {
                log.error("Can't load all the custom package list - user-defined classes may not be recognized", e);
            }
        } else {
            log.debug("No user-defined packages for version " + version);
        }
        packageList.add(DefaultModelClassFactory.getVersionPackageName(version));
        retVal = packageList.toArray(new String[0]);
        return retVal;
    }

    private static Class<?> findClass(String name, String version, String type) throws HL7Exception {
        if (!Parser.validVersion(version)) {
            throw new HL7Exception("The HL7 version " + version + " is not recognized", 203);
        }
        String[] packageList = DefaultModelClassFactory.packageList(version);
        if (packageList == null) {
            return null;
        }
        String types = "message|group|segment|datatype";
        if (types.indexOf(type) < 0) {
            throw new HL7Exception("Can't find " + name + " for version " + version + " -- type must be " + types + " but is " + type);
        }
        String subpackage = type;
        Class<?> compClass = null;
        int c = 0;
        while (compClass == null && c < packageList.length) {
            String classNameToTry = null;
            try {
                String p = packageList[c];
                if (!p.endsWith(".")) {
                    p = String.valueOf(p) + ".";
                }
                classNameToTry = String.valueOf(p) + subpackage + "." + name;
                if (log.isDebugEnabled()) {
                    log.debug("Trying to load: " + classNameToTry);
                }
                compClass = Class.forName(classNameToTry);
                if (log.isDebugEnabled()) {
                    log.debug("Loaded: " + classNameToTry + " class: " + compClass);
                }
            }
            catch (ClassNotFoundException cne) {
                log.debug("Failed to load: " + classNameToTry);
            }
            ++c;
        }
        return compClass;
    }

    public static void reloadPackages() {
        packages.clear();
        ourVersions = new ArrayList<String>();
        List<String> versions = Parser.getValidVersions();
        for (String version : versions) {
            try {
                String[] versionPackages = DefaultModelClassFactory.loadPackages(version);
                if (versionPackages.length > 0) {
                    ourVersions.add(version);
                }
                packages.put(version, versionPackages);
            }
            catch (HL7Exception e) {
                throw new Error("Version \"" + version + "\" is invalid. This is a programming error: ", e);
            }
        }
    }

    public static String getHighestKnownVersion() {
        if (ourVersions == null || ourVersions.size() == 0) {
            return null;
        }
        return ourVersions.get(ourVersions.size() - 1);
    }
}

