/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="XlaSpmdShardToFullShape", inputsClass=Inputs.class)
public final class SpmdShardToFullShape<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "XlaSpmdShardToFullShape";
    private Output<T> output;

    public SpmdShardToFullShape(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> SpmdShardToFullShape<T> create(Scope scope, Operand<T> input, String manualSharding, Shape fullShape, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "SpmdShardToFullShape");
        opBuilder.addInput(input.asOutput());
        opBuilder.setAttr("manual_sharding", manualSharding);
        opBuilder.setAttr("full_shape", fullShape);
        if (options != null) {
            for (Options opts : options) {
                if (opts.dim != null) {
                    opBuilder.setAttr("dim", opts.dim);
                }
                if (opts.unspecifiedDims == null) continue;
                long[] unspecifiedDimsArray = new long[opts.unspecifiedDims.size()];
                for (int i = 0; i < unspecifiedDimsArray.length; ++i) {
                    unspecifiedDimsArray[i] = opts.unspecifiedDims.get(i);
                }
                opBuilder.setAttr("unspecified_dims", unspecifiedDimsArray);
            }
        }
        return new SpmdShardToFullShape<T>(opBuilder.build());
    }

    public static Options dim(Long dim) {
        return new Options().dim(dim);
    }

    public static Options unspecifiedDims(List<Long> unspecifiedDims) {
        return new Options().unspecifiedDims(unspecifiedDims);
    }

    public static Options unspecifiedDims(Long ... unspecifiedDims) {
        return new Options().unspecifiedDims(unspecifiedDims);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=SpmdShardToFullShape.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<SpmdShardToFullShape<T>> {
        public final Operand<T> input;
        public final DataType T;
        public final String manualSharding;
        public final Shape fullShape;
        public final long dim;
        public final long[] unspecifiedDims;

        public Inputs(GraphOperation op) {
            super(new SpmdShardToFullShape(op), op, Arrays.asList("T", "manual_sharding", "full_shape", "dim", "unspecified_dims"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.manualSharding = op.attributes().getAttrString("manual_sharding");
            this.fullShape = op.attributes().getAttrShape("full_shape");
            this.dim = op.attributes().getAttrInt("dim");
            this.unspecifiedDims = op.attributes().getAttrIntList("unspecified_dims");
        }
    }

    public static class Options {
        private Long dim;
        private List<Long> unspecifiedDims;

        private Options() {
        }

        public Options dim(Long dim) {
            this.dim = dim;
            return this;
        }

        public Options unspecifiedDims(List<Long> unspecifiedDims) {
            this.unspecifiedDims = unspecifiedDims;
            return this;
        }

        public Options unspecifiedDims(Long ... unspecifiedDims) {
            this.unspecifiedDims = Arrays.asList(unspecifiedDims);
            return this;
        }
    }
}

