/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="OutfeedDequeueTuple", inputsClass=Inputs.class)
public final class OutfeedDequeueTuple
extends RawOp
implements Iterable<Operand<TType>> {
    public static final String OP_NAME = "OutfeedDequeueTuple";
    private List<Output<?>> outputs;

    public OutfeedDequeueTuple(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int outputsLength = operation.outputListLength("outputs");
        this.outputs = Arrays.asList(operation.outputList(outputIdx, outputsLength));
        outputIdx += outputsLength;
    }

    public static OutfeedDequeueTuple create(Scope scope, List<Class<? extends TType>> dtypes, List<Shape> shapes, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.setAttr("dtypes", Operands.toDataTypes(dtypes));
        Shape[] shapesArray = new Shape[shapes.size()];
        for (int i = 0; i < shapesArray.length; ++i) {
            shapesArray[i] = shapes.get(i);
        }
        opBuilder.setAttr("shapes", shapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.deviceOrdinal == null) continue;
                opBuilder.setAttr("device_ordinal", opts.deviceOrdinal);
            }
        }
        return new OutfeedDequeueTuple(opBuilder.build());
    }

    public static Options deviceOrdinal(Long deviceOrdinal) {
        return new Options().deviceOrdinal(deviceOrdinal);
    }

    public List<Output<?>> outputs() {
        return this.outputs;
    }

    @Override
    public Iterator<Operand<TType>> iterator() {
        return this.outputs.iterator();
    }

    @OpInputsMetadata(outputsClass=OutfeedDequeueTuple.class)
    public static class Inputs
    extends RawOpInputs<OutfeedDequeueTuple> {
        public final DataType[] dtypes;
        public final Shape[] shapes;
        public final long deviceOrdinal;

        public Inputs(GraphOperation op) {
            super(new OutfeedDequeueTuple(op), op, Arrays.asList("dtypes", "shapes", "device_ordinal"));
            boolean inputIndex = false;
            this.dtypes = op.attributes().getAttrTypeList("dtypes");
            this.shapes = op.attributes().getAttrShapeList("shapes");
            this.deviceOrdinal = op.attributes().getAttrInt("device_ordinal");
        }
    }

    public static class Options {
        private Long deviceOrdinal;

        private Options() {
        }

        public Options deviceOrdinal(Long deviceOrdinal) {
            this.deviceOrdinal = deviceOrdinal;
            return this;
        }
    }
}

