/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.io;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="FixedLengthRecordReaderV2", inputsClass=Inputs.class)
public final class FixedLengthRecordReader
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "FixedLengthRecordReaderV2";
    private Output<? extends TType> readerHandle;

    public FixedLengthRecordReader(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.readerHandle = operation.output(outputIdx++);
    }

    public static FixedLengthRecordReader create(Scope scope, Long recordBytes, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "FixedLengthRecordReader");
        opBuilder.setAttr("record_bytes", recordBytes);
        if (options != null) {
            for (Options opts : options) {
                if (opts.headerBytes != null) {
                    opBuilder.setAttr("header_bytes", opts.headerBytes);
                }
                if (opts.footerBytes != null) {
                    opBuilder.setAttr("footer_bytes", opts.footerBytes);
                }
                if (opts.hopBytes != null) {
                    opBuilder.setAttr("hop_bytes", opts.hopBytes);
                }
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName != null) {
                    opBuilder.setAttr("shared_name", opts.sharedName);
                }
                if (opts.encoding == null) continue;
                opBuilder.setAttr("encoding", opts.encoding);
            }
        }
        return new FixedLengthRecordReader(opBuilder.build());
    }

    public static Options headerBytes(Long headerBytes) {
        return new Options().headerBytes(headerBytes);
    }

    public static Options footerBytes(Long footerBytes) {
        return new Options().footerBytes(footerBytes);
    }

    public static Options hopBytes(Long hopBytes) {
        return new Options().hopBytes(hopBytes);
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public static Options encoding(String encoding) {
        return new Options().encoding(encoding);
    }

    public Output<? extends TType> readerHandle() {
        return this.readerHandle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.readerHandle;
    }

    @OpInputsMetadata(outputsClass=FixedLengthRecordReader.class)
    public static class Inputs
    extends RawOpInputs<FixedLengthRecordReader> {
        public final long headerBytes;
        public final long recordBytes;
        public final long footerBytes;
        public final long hopBytes;
        public final String container;
        public final String sharedName;
        public final String encoding;

        public Inputs(GraphOperation op) {
            super(new FixedLengthRecordReader(op), op, Arrays.asList("header_bytes", "record_bytes", "footer_bytes", "hop_bytes", "container", "shared_name", "encoding"));
            boolean inputIndex = false;
            this.headerBytes = op.attributes().getAttrInt("header_bytes");
            this.recordBytes = op.attributes().getAttrInt("record_bytes");
            this.footerBytes = op.attributes().getAttrInt("footer_bytes");
            this.hopBytes = op.attributes().getAttrInt("hop_bytes");
            this.container = op.attributes().getAttrString("container");
            this.sharedName = op.attributes().getAttrString("shared_name");
            this.encoding = op.attributes().getAttrString("encoding");
        }
    }

    public static class Options {
        private Long headerBytes;
        private Long footerBytes;
        private Long hopBytes;
        private String container;
        private String sharedName;
        private String encoding;

        private Options() {
        }

        public Options headerBytes(Long headerBytes) {
            this.headerBytes = headerBytes;
            return this;
        }

        public Options footerBytes(Long footerBytes) {
            this.footerBytes = footerBytes;
            return this;
        }

        public Options hopBytes(Long hopBytes) {
            this.hopBytes = hopBytes;
            return this;
        }

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        public Options encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }
    }
}

