/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.sparse;

import java.nio.ReadOnlyBufferException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.tensorflow.ndarray.BooleanNdArray;
import org.tensorflow.ndarray.LongNdArray;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.NdArrays;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.ndarray.StdArrays;
import org.tensorflow.ndarray.buffer.BooleanDataBuffer;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.DataBuffers;
import org.tensorflow.ndarray.impl.dimension.DimensionalSpace;
import org.tensorflow.ndarray.impl.sparse.AbstractSparseNdArray;
import org.tensorflow.ndarray.impl.sparse.slice.BooleanSparseSlice;
import org.tensorflow.ndarray.index.Index;

public class BooleanSparseNdArray
extends AbstractSparseNdArray<Boolean, BooleanNdArray>
implements BooleanNdArray {
    protected BooleanSparseNdArray(LongNdArray indices, BooleanNdArray values, boolean defaultValue, DimensionalSpace dimensions) {
        super(indices, values, defaultValue, dimensions);
    }

    BooleanSparseNdArray(LongNdArray indices, BooleanNdArray values, DimensionalSpace dimensions) {
        this(indices, values, false, dimensions);
    }

    BooleanSparseNdArray(BooleanDataBuffer dataBuffer, DimensionalSpace dimensions) {
        this(dataBuffer, false, dimensions);
    }

    BooleanSparseNdArray(BooleanDataBuffer dataBuffer, boolean defaultValue, DimensionalSpace dimensions) {
        super(defaultValue, dimensions);
        this.write(dataBuffer);
    }

    BooleanSparseNdArray(DimensionalSpace dimensions) {
        this(false, dimensions);
    }

    BooleanSparseNdArray(boolean defaultValue, DimensionalSpace dimensions) {
        super(defaultValue, dimensions);
    }

    public static BooleanSparseNdArray create(LongNdArray indices, BooleanNdArray values, DimensionalSpace dimensions) {
        return new BooleanSparseNdArray(indices, values, dimensions);
    }

    public static BooleanSparseNdArray create(LongNdArray indices, BooleanNdArray values, boolean defaultValue, DimensionalSpace dimensions) {
        return new BooleanSparseNdArray(indices, values, defaultValue, dimensions);
    }

    public static BooleanSparseNdArray create(BooleanDataBuffer dataBuffer, DimensionalSpace dimensions) {
        return new BooleanSparseNdArray(dataBuffer, dimensions);
    }

    public static BooleanSparseNdArray create(BooleanDataBuffer dataBuffer, boolean defaultValue, DimensionalSpace dimensions) {
        return new BooleanSparseNdArray(dataBuffer, defaultValue, dimensions);
    }

    public static BooleanSparseNdArray create(DimensionalSpace dimensions) {
        return new BooleanSparseNdArray(dimensions);
    }

    public static BooleanSparseNdArray create(boolean defaultValue, DimensionalSpace dimensions) {
        return new BooleanSparseNdArray(defaultValue, dimensions);
    }

    public static BooleanSparseNdArray create(BooleanDataBuffer buffer, Shape shape) {
        return new BooleanSparseNdArray(buffer, DimensionalSpace.create(shape));
    }

    public static BooleanSparseNdArray create(BooleanDataBuffer buffer, boolean defaultValue, Shape shape) {
        return new BooleanSparseNdArray(buffer, defaultValue, DimensionalSpace.create(shape));
    }

    public static BooleanSparseNdArray create(BooleanNdArray src) {
        BooleanDataBuffer buffer = DataBuffers.ofBooleans(src.size());
        src.read(buffer);
        return new BooleanSparseNdArray(buffer, DimensionalSpace.create(src.shape()));
    }

    public static BooleanSparseNdArray create(BooleanNdArray src, boolean defaultValue) {
        BooleanDataBuffer buffer = DataBuffers.ofBooleans(src.size());
        src.read(buffer);
        return new BooleanSparseNdArray(buffer, defaultValue, DimensionalSpace.create(src.shape()));
    }

    @Override
    public BooleanNdArray createDefaultArray() {
        return NdArrays.scalarOf((Boolean)this.getDefaultValue());
    }

    @Override
    public BooleanNdArray createValues(Shape shape) {
        return NdArrays.ofBooleans(shape);
    }

    @Override
    public BooleanNdArray slice(long position, DimensionalSpace sliceDimensions) {
        return new BooleanSparseSlice(this, position, sliceDimensions);
    }

    @Override
    public boolean getBoolean(long ... coordinates) {
        return (Boolean)this.getObject(coordinates);
    }

    @Override
    public BooleanNdArray setBoolean(boolean value, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public BooleanNdArray read(DataBuffer<Boolean> dst) {
        return this.read((BooleanDataBuffer)dst);
    }

    @Override
    public BooleanNdArray read(BooleanDataBuffer dst) {
        Object[] defaults = new Boolean[(int)this.shape().size()];
        Arrays.fill(defaults, this.getDefaultValue());
        dst.write(defaults);
        AtomicInteger i = new AtomicInteger();
        this.getIndices().elements(0).forEachIndexed((idx, l) -> {
            long[] coordinates = this.getIndicesCoordinates((LongNdArray)l);
            boolean value = ((BooleanNdArray)this.getValues()).getBoolean(i.getAndIncrement());
            dst.setObject(value, this.dimensions.positionOf(coordinates));
        });
        return this;
    }

    @Override
    public BooleanNdArray write(BooleanDataBuffer src) {
        ArrayList<long[]> indices = new ArrayList<long[]>();
        ArrayList<Boolean> values = new ArrayList<Boolean>();
        for (long i = 0L; i < src.size(); ++i) {
            if (src.getObject(i).equals(this.getDefaultValue())) continue;
            indices.add(this.toCoordinates(this.dimensions, i));
            values.add(src.getObject(i));
        }
        long[][] indicesArray = new long[indices.size()][];
        boolean[] valuesArray = new boolean[values.size()];
        for (int i = 0; i < indices.size(); ++i) {
            indicesArray[i] = (long[])indices.get(i);
            valuesArray[i] = (Boolean)values.get(i);
        }
        this.setIndices(StdArrays.ndCopyOf(indicesArray));
        this.setValues(NdArrays.vectorOf(valuesArray));
        return this;
    }

    @Override
    public BooleanNdArray write(DataBuffer<Boolean> src) {
        return this.write((BooleanDataBuffer)src);
    }

    @Override
    public BooleanNdArray toDense() {
        BooleanDataBuffer dataBuffer = DataBuffers.ofBooleans(this.shape().size());
        this.read(dataBuffer);
        return NdArrays.wrap(this.shape(), dataBuffer);
    }

    public BooleanNdArray fromDense(BooleanNdArray src) {
        BooleanDataBuffer buffer = DataBuffers.ofBooleans(src.size());
        src.read(buffer);
        this.write(buffer);
        return this;
    }

    @Override
    public BooleanNdArray slice(Index ... indices) {
        return (BooleanNdArray)super.slice(indices);
    }

    @Override
    public BooleanNdArray get(long ... coordinates) {
        return (BooleanNdArray)super.get(coordinates);
    }

    @Override
    public BooleanNdArray setObject(Boolean value, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public BooleanNdArray set(NdArray<Boolean> src, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public BooleanNdArray copyTo(NdArray<Boolean> dst) {
        return (BooleanNdArray)super.copyTo(dst);
    }
}

