/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.train;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;

@OpMetadata(opType="GenerateVocabRemapping", inputsClass=Inputs.class)
public final class GenerateVocabRemapping
extends RawOp {
    public static final String OP_NAME = "GenerateVocabRemapping";
    private Output<TInt64> remapping;
    private Output<TInt32> numPresent;

    public GenerateVocabRemapping(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.remapping = operation.output(outputIdx++);
        this.numPresent = operation.output(outputIdx++);
    }

    public static GenerateVocabRemapping create(Scope scope, Operand<TString> newVocabFile, Operand<TString> oldVocabFile, Long newVocabOffset, Long numNewVocab, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(newVocabFile.asOutput());
        opBuilder.addInput(oldVocabFile.asOutput());
        opBuilder.setAttr("new_vocab_offset", newVocabOffset);
        opBuilder.setAttr("num_new_vocab", numNewVocab);
        if (options != null) {
            for (Options opts : options) {
                if (opts.oldVocabSize == null) continue;
                opBuilder.setAttr("old_vocab_size", opts.oldVocabSize);
            }
        }
        return new GenerateVocabRemapping(opBuilder.build());
    }

    public static Options oldVocabSize(Long oldVocabSize) {
        return new Options().oldVocabSize(oldVocabSize);
    }

    public Output<TInt64> remapping() {
        return this.remapping;
    }

    public Output<TInt32> numPresent() {
        return this.numPresent;
    }

    @OpInputsMetadata(outputsClass=GenerateVocabRemapping.class)
    public static class Inputs
    extends RawOpInputs<GenerateVocabRemapping> {
        public final Operand<TString> newVocabFile;
        public final Operand<TString> oldVocabFile;
        public final long newVocabOffset;
        public final long numNewVocab;
        public final long oldVocabSize;

        public Inputs(GraphOperation op) {
            super(new GenerateVocabRemapping(op), op, Arrays.asList("new_vocab_offset", "num_new_vocab", "old_vocab_size"));
            int inputIndex = 0;
            this.newVocabFile = op.input(inputIndex++);
            this.oldVocabFile = op.input(inputIndex++);
            this.newVocabOffset = op.attributes().getAttrInt("new_vocab_offset");
            this.numNewVocab = op.attributes().getAttrInt("num_new_vocab");
            this.oldVocabSize = op.attributes().getAttrInt("old_vocab_size");
        }
    }

    public static class Options {
        private Long oldVocabSize;

        private Options() {
        }

        public Options oldVocabSize(Long oldVocabSize) {
            this.oldVocabSize = oldVocabSize;
            return this;
        }
    }
}

