/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TString;

@OpMetadata(opType="EnqueueTPUEmbeddingIntegerBatch", inputsClass=Inputs.class)
public final class EnqueueTPUEmbeddingIntegerBatch
extends RawOp {
    public static final String OP_NAME = "EnqueueTPUEmbeddingIntegerBatch";

    public EnqueueTPUEmbeddingIntegerBatch(Operation operation) {
        super(operation, OP_NAME);
    }

    public static EnqueueTPUEmbeddingIntegerBatch create(Scope scope, Iterable<Operand<TInt32>> batch, Operand<TString> modeOverride, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(batch));
        opBuilder.addInput(modeOverride.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.deviceOrdinal == null) continue;
                opBuilder.setAttr("device_ordinal", opts.deviceOrdinal);
            }
        }
        return new EnqueueTPUEmbeddingIntegerBatch(opBuilder.build());
    }

    public static Options deviceOrdinal(Long deviceOrdinal) {
        return new Options().deviceOrdinal(deviceOrdinal);
    }

    @OpInputsMetadata(outputsClass=EnqueueTPUEmbeddingIntegerBatch.class)
    public static class Inputs
    extends RawOpInputs<EnqueueTPUEmbeddingIntegerBatch> {
        public final Iterable<Operand<TInt32>> batch;
        public final Operand<TString> modeOverride;
        public final long deviceOrdinal;

        public Inputs(GraphOperation op) {
            super(new EnqueueTPUEmbeddingIntegerBatch(op), op, Arrays.asList("device_ordinal"));
            int inputIndex = 0;
            int batchLength = op.inputListLength("batch");
            this.batch = Arrays.asList((Operand[])op.inputList(inputIndex, batchLength));
            inputIndex += batchLength;
            this.modeOverride = op.input(inputIndex++);
            this.deviceOrdinal = op.attributes().getAttrInt("device_ordinal");
        }
    }

    public static class Options {
        private Long deviceOrdinal;

        private Options() {
        }

        public Options deviceOrdinal(Long deviceOrdinal) {
            this.deviceOrdinal = deviceOrdinal;
            return this;
        }
    }
}

