/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="RegisterDatasetV2", inputsClass=Inputs.class)
public final class RegisterDataset
extends RawOp
implements Operand<TString> {
    public static final String OP_NAME = "RegisterDatasetV2";
    private Output<TString> datasetId;

    public RegisterDataset(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.datasetId = operation.output(outputIdx++);
    }

    public static RegisterDataset create(Scope scope, Operand<? extends TType> dataset, Operand<TString> address, Operand<TString> protocol, Long externalStatePolicy, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "RegisterDataset");
        opBuilder.addInput(dataset.asOutput());
        opBuilder.addInput(address.asOutput());
        opBuilder.addInput(protocol.asOutput());
        opBuilder.setAttr("external_state_policy", externalStatePolicy);
        if (options != null) {
            for (Options opts : options) {
                if (opts.elementSpec != null) {
                    opBuilder.setAttr("element_spec", opts.elementSpec);
                }
                if (opts.requestedDatasetId != null) {
                    opBuilder.setAttr("requested_dataset_id", opts.requestedDatasetId);
                }
                if (opts.metadata == null) continue;
                opBuilder.setAttr("metadata", opts.metadata);
            }
        }
        return new RegisterDataset(opBuilder.build());
    }

    public static Options elementSpec(String elementSpec) {
        return new Options().elementSpec(elementSpec);
    }

    public static Options requestedDatasetId(String requestedDatasetId) {
        return new Options().requestedDatasetId(requestedDatasetId);
    }

    public static Options metadata(String metadata) {
        return new Options().metadata(metadata);
    }

    public Output<TString> datasetId() {
        return this.datasetId;
    }

    @Override
    public Output<TString> asOutput() {
        return this.datasetId;
    }

    @OpInputsMetadata(outputsClass=RegisterDataset.class)
    public static class Inputs
    extends RawOpInputs<RegisterDataset> {
        public final Operand<? extends TType> dataset;
        public final Operand<TString> address;
        public final Operand<TString> protocol;
        public final long externalStatePolicy;
        public final String elementSpec;
        public final String requestedDatasetId;
        public final String metadata;

        public Inputs(GraphOperation op) {
            super(new RegisterDataset(op), op, Arrays.asList("external_state_policy", "element_spec", "requested_dataset_id", "metadata"));
            int inputIndex = 0;
            this.dataset = op.input(inputIndex++);
            this.address = op.input(inputIndex++);
            this.protocol = op.input(inputIndex++);
            this.externalStatePolicy = op.attributes().getAttrInt("external_state_policy");
            this.elementSpec = op.attributes().getAttrString("element_spec");
            this.requestedDatasetId = op.attributes().getAttrString("requested_dataset_id");
            this.metadata = op.attributes().getAttrString("metadata");
        }
    }

    public static class Options {
        private String elementSpec;
        private String requestedDatasetId;
        private String metadata;

        private Options() {
        }

        public Options elementSpec(String elementSpec) {
            this.elementSpec = elementSpec;
            return this;
        }

        public Options requestedDatasetId(String requestedDatasetId) {
            this.requestedDatasetId = requestedDatasetId;
            return this;
        }

        public Options metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }
    }
}

