/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.output;

import ai.djl.modality.Classifications;
import ai.djl.modality.cv.output.BoundingBox;
import ai.djl.util.JsonUtils;
import com.google.gson.Gson;
import java.util.List;

public class DetectedObjects
extends Classifications {
    private static final long serialVersionUID = 1L;
    private static final Gson GSON = JsonUtils.builder().registerTypeAdapter(DetectedObjects.class, (Object)new Classifications.ClassificationsSerializer()).create();
    private List<BoundingBox> boundingBoxes;

    public DetectedObjects(List<String> classNames, List<Double> probabilities, List<BoundingBox> boundingBoxes) {
        super(classNames, probabilities);
        this.boundingBoxes = boundingBoxes;
        this.setTopK(Integer.MAX_VALUE);
    }

    @Override
    public <T extends Classifications.Classification> T item(int index) {
        return (T)new DetectedObject((String)this.classNames.get(index), (Double)this.probabilities.get(index), this.boundingBoxes.get(index));
    }

    public int getNumberOfObjects() {
        return this.boundingBoxes.size();
    }

    @Override
    public String toJson() {
        return GSON.toJson((Object)this) + '\n';
    }

    public static final class DetectedObject
    extends Classifications.Classification {
        private BoundingBox boundingBox;

        public DetectedObject(String className, double probability, BoundingBox boundingBox) {
            super(className, probability);
            this.boundingBox = boundingBox;
        }

        public BoundingBox getBoundingBox() {
            return this.boundingBox;
        }

        @Override
        public String toString() {
            double probability = this.getProbability();
            StringBuilder sb = new StringBuilder(200);
            sb.append("{\"class\": \"").append(this.getClassName()).append("\", \"probability\": ");
            if (probability < 1.0E-5) {
                sb.append(String.format("%.1e", probability));
            } else {
                probability = (float)((int)(probability * 100000.0)) / 100000.0f;
                sb.append(String.format("%.5f", probability));
            }
            if (this.getBoundingBox() != null) {
                sb.append(", \"bounds\": ").append(this.getBoundingBox());
            }
            sb.append('}');
            return sb.toString();
        }
    }
}

