/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.admin.core.util;

import com.xxl.job.admin.core.conf.XxlJobAdminConfig;
import com.xxl.job.admin.core.util.JacksonUtil;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class I18nUtil {
    private static Logger logger = LoggerFactory.getLogger(I18nUtil.class);
    private static Properties prop = null;

    public static Properties loadI18nProp() {
        if (prop != null) {
            return prop;
        }
        try {
            String i18n = XxlJobAdminConfig.getAdminConfig().getI18n();
            String i18nFile = MessageFormat.format("i18n/message_{0}.properties", i18n);
            ClassPathResource resource = new ClassPathResource(i18nFile);
            EncodedResource encodedResource = new EncodedResource((Resource)resource, "UTF-8");
            prop = PropertiesLoaderUtils.loadProperties((EncodedResource)encodedResource);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return prop;
    }

    public static String getString(String key) {
        return I18nUtil.loadI18nProp().getProperty(key);
    }

    public static String getMultString(String ... keys) {
        HashMap<String, String> map = new HashMap<String, String>();
        Properties prop = I18nUtil.loadI18nProp();
        if (keys != null && keys.length > 0) {
            for (String key : keys) {
                map.put(key, prop.getProperty(key));
            }
        } else {
            for (String key : prop.stringPropertyNames()) {
                map.put(key, prop.getProperty(key));
            }
        }
        String json = JacksonUtil.writeValueAsString(map);
        return json;
    }
}

