/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.admin.controller;

import com.xxl.job.admin.controller.annotation.PermissionLimit;
import com.xxl.job.admin.core.conf.XxlJobAdminConfig;
import com.xxl.job.core.biz.AdminBiz;
import com.xxl.job.core.biz.model.HandleCallbackParam;
import com.xxl.job.core.biz.model.RegistryParam;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.util.GsonTool;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api"})
public class JobApiController {
    @Resource
    private AdminBiz adminBiz;

    @RequestMapping(value={"/{uri}"})
    @ResponseBody
    @PermissionLimit(limit=false)
    public ReturnT<String> api(HttpServletRequest request, @PathVariable(value="uri") String uri, @RequestBody(required=false) String data) {
        if (!"POST".equalsIgnoreCase(request.getMethod())) {
            return new ReturnT(500, "invalid request, HttpMethod not support.");
        }
        if (uri == null || uri.trim().length() == 0) {
            return new ReturnT(500, "invalid request, uri-mapping empty.");
        }
        if (XxlJobAdminConfig.getAdminConfig().getAccessToken() != null && XxlJobAdminConfig.getAdminConfig().getAccessToken().trim().length() > 0 && !XxlJobAdminConfig.getAdminConfig().getAccessToken().equals(request.getHeader("XXL-JOB-ACCESS-TOKEN"))) {
            return new ReturnT(500, "The access token is wrong.");
        }
        if ("callback".equals(uri)) {
            List callbackParamList = (List)GsonTool.fromJson((String)data, List.class, HandleCallbackParam.class);
            return this.adminBiz.callback(callbackParamList);
        }
        if ("registry".equals(uri)) {
            RegistryParam registryParam = (RegistryParam)GsonTool.fromJson((String)data, RegistryParam.class);
            return this.adminBiz.registry(registryParam);
        }
        if ("registryRemove".equals(uri)) {
            RegistryParam registryParam = (RegistryParam)GsonTool.fromJson((String)data, RegistryParam.class);
            return this.adminBiz.registryRemove(registryParam);
        }
        return new ReturnT(500, "invalid request, uri-mapping(" + uri + ") not found.");
    }
}

