/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.swagger.config;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.configuration.SpringDocConfiguration;
import org.springdoc.core.customizers.GlobalOpenApiCustomizer;
import org.springdoc.core.models.GroupedOpenApi;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.violet.common.core.util.CollectionUtil;
import org.violet.common.swagger.config.SwaggerProperties;

@Configuration
@AutoConfigureBefore(value={SpringDocConfiguration.class})
@EnableConfigurationProperties(value={SwaggerProperties.class})
@ConditionalOnProperty(value={"swagger.enabled"}, havingValue="true", matchIfMissing=true)
public class SwaggerAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SwaggerAutoConfiguration.class);
    private static final String DEFAULT_BASE_PATH = "/**";
    private static final List<String> DEFAULT_EXCLUDE_PATH = Arrays.asList("/error", "/actuator/**");
    private static final String TOKEN_HEADER = "token";
    private final SwaggerProperties swaggerProperties;

    @Bean
    public OpenAPI openApi() {
        return new OpenAPI().components(new Components().addSecuritySchemes(TOKEN_HEADER, new SecurityScheme().type(SecurityScheme.Type.APIKEY).in(SecurityScheme.In.HEADER).name(TOKEN_HEADER))).info(new Info().title(this.swaggerProperties.getTitle()).description(this.swaggerProperties.getDescription()).termsOfService(this.swaggerProperties.getTermsOfServiceUrl()).contact(new Contact().name(this.swaggerProperties.getContact().getName()).email(this.swaggerProperties.getContact().getEmail()).url(this.swaggerProperties.getContact().getUrl())).license(new License().name(this.swaggerProperties.getLicense()).url(this.swaggerProperties.getLicenseUrl())).version(this.swaggerProperties.getVersion()));
    }

    @Bean
    public GlobalOpenApiCustomizer orderGlobalOpenApiCustomizer() {
        return openApi -> {
            if (openApi.getPaths() != null) {
                openApi.getPaths().forEach((s, pathItem) -> pathItem.readOperations().forEach(operation -> operation.addSecurityItem(new SecurityRequirement().addList(TOKEN_HEADER))));
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean
    public GroupedOpenApi defaultApi() {
        if (CollectionUtil.isEmpty(this.swaggerProperties.getBasePath())) {
            this.swaggerProperties.getBasePath().add(DEFAULT_BASE_PATH);
        }
        if (CollectionUtil.isEmpty(this.swaggerProperties.getExcludePath())) {
            this.swaggerProperties.getExcludePath().addAll(DEFAULT_EXCLUDE_PATH);
        }
        List<String> basePath = this.swaggerProperties.getBasePath();
        List<String> excludePath = this.swaggerProperties.getExcludePath();
        List<String> basePackages = this.swaggerProperties.getBasePackages();
        List<String> excludePackages = this.swaggerProperties.getExcludePackages();
        return GroupedOpenApi.builder().group("default").pathsToMatch(basePath.toArray(new String[0])).pathsToExclude(excludePath.toArray(new String[0])).packagesToScan(basePackages.toArray(new String[0])).packagesToExclude(excludePackages.toArray(new String[0])).build();
    }

    @Generated
    public SwaggerAutoConfiguration(SwaggerProperties swaggerProperties) {
        this.swaggerProperties = swaggerProperties;
    }
}

