/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.mybatis.support;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.ContentType;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import jakarta.servlet.http.HttpServletRequest;
import java.io.InputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.violet.common.mybatis.pojo.PageRequest;

public class PageRequestHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PageRequestHandlerMethodArgumentResolver.class);
    public static final String CURRENT_PAGE = "current";
    public static final String PAGE_SIZE = "size";
    public static final String SORTS = "_sorts";
    public static final String ORDERS = "_orders";

    public boolean supportsParameter(MethodParameter methodParameter) {
        return methodParameter.getParameterType().isAssignableFrom(PageRequest.class);
    }

    public Object resolveArgument(MethodParameter methodParameter, ModelAndViewContainer modelAndViewContainer, NativeWebRequest nativeWebRequest, WebDataBinderFactory webDataBinderFactory) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)nativeWebRequest.getNativeRequest();
        try {
            String contentTypeStr = httpServletRequest.getContentType();
            if (StrUtil.contains((CharSequence)contentTypeStr, (CharSequence)ContentType.JSON.getValue())) {
                String bodyJsonStr = IoUtil.readUtf8((InputStream)httpServletRequest.getInputStream());
                JSONObject jsonObject = JSON.parseObject((String)bodyJsonStr);
                long currentPage = jsonObject.getLongValue(CURRENT_PAGE);
                long pageSize = jsonObject.getLongValue(PAGE_SIZE, 20L);
                PageRequest page = PageRequest.of(currentPage, pageSize);
                page.buildSorts(jsonObject.getString(SORTS), jsonObject.getString(ORDERS));
                return page;
            }
            if (StrUtil.isBlank((CharSequence)contentTypeStr) || StrUtil.contains((CharSequence)contentTypeStr, (CharSequence)ContentType.FORM_URLENCODED.getValue())) {
                long currentPage = NumberUtil.parseLong((String)nativeWebRequest.getParameter(CURRENT_PAGE));
                long pageSize = NumberUtil.parseLong((String)nativeWebRequest.getParameter(PAGE_SIZE));
                PageRequest page = PageRequest.of(currentPage, pageSize);
                page.buildSorts(nativeWebRequest.getParameter(SORTS), nativeWebRequest.getParameter(ORDERS));
                return page;
            }
            log.warn("\u6784\u9020PageRequest\u5931\u8d25,\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u65b9\u5f0f:" + contentTypeStr);
        }
        catch (Exception var14) {
            log.error(var14.getMessage(), (Throwable)var14);
        }
        return new PageRequest();
    }
}

