/*
 * Decompiled with CFR 0.152.
 */
package org.violet.commom.crypto.util;

import java.lang.reflect.Method;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.violet.commom.crypto.annotation.decrypt.ApiDecrypt;
import org.violet.commom.crypto.annotation.encrypt.ApiEncrypt;
import org.violet.commom.crypto.bean.CryptoInfoBean;
import org.violet.commom.crypto.config.ApiCryptoProperties;
import org.violet.commom.crypto.enums.CryptoType;
import org.violet.commom.crypto.exception.EncryptBodyFailException;
import org.violet.commom.crypto.exception.EncryptMethodNotFoundException;
import org.violet.commom.crypto.exception.KeyNotConfiguredException;
import org.violet.common.core.util.AesUtil;
import org.violet.common.core.util.ClassUtil;
import org.violet.common.core.util.DesUtil;
import org.violet.common.core.util.StringUtil;

public class ApiCryptoUtil {
    @Nullable
    public static CryptoInfoBean getEncryptInfo(MethodParameter methodParameter) {
        ApiEncrypt encryptBody = (ApiEncrypt)ClassUtil.getAnnotation((Method)methodParameter.getMethod(), ApiEncrypt.class);
        if (encryptBody == null) {
            return null;
        }
        return new CryptoInfoBean(encryptBody.value(), encryptBody.secretKey());
    }

    @Nullable
    public static CryptoInfoBean getDecryptInfo(MethodParameter methodParameter) {
        ApiDecrypt decryptBody = (ApiDecrypt)ClassUtil.getAnnotation((Method)methodParameter.getMethod(), ApiDecrypt.class);
        if (decryptBody == null) {
            return null;
        }
        return new CryptoInfoBean(decryptBody.value(), decryptBody.secretKey());
    }

    public static String encryptData(ApiCryptoProperties properties, byte[] jsonData, CryptoInfoBean infoBean) {
        CryptoType type = infoBean.getType();
        if (type == null) {
            throw new EncryptMethodNotFoundException();
        }
        String secretKey = infoBean.getSecretKey();
        if (type == CryptoType.DES) {
            secretKey = ApiCryptoUtil.checkSecretKey(properties.getDesKey(), secretKey, "DES");
            return DesUtil.encryptToBase64((byte[])jsonData, (String)secretKey);
        }
        if (type == CryptoType.AES) {
            secretKey = ApiCryptoUtil.checkSecretKey(properties.getAesKey(), secretKey, "AES");
            return AesUtil.encryptToBase64((byte[])jsonData, (String)secretKey);
        }
        throw new EncryptBodyFailException();
    }

    public static byte[] decryptData(ApiCryptoProperties properties, byte[] bodyData, CryptoInfoBean infoBean) {
        CryptoType type = infoBean.getType();
        if (type == null) {
            throw new EncryptMethodNotFoundException();
        }
        String secretKey = infoBean.getSecretKey();
        if (type == CryptoType.AES) {
            secretKey = ApiCryptoUtil.checkSecretKey(properties.getAesKey(), secretKey, "AES");
            return AesUtil.decryptFormBase64((byte[])bodyData, (String)secretKey);
        }
        if (type == CryptoType.DES) {
            secretKey = ApiCryptoUtil.checkSecretKey(properties.getDesKey(), secretKey, "DES");
            return DesUtil.decryptFormBase64((byte[])bodyData, (String)secretKey);
        }
        throw new EncryptMethodNotFoundException();
    }

    private static String checkSecretKey(String k1, String k2, String keyName) {
        if (StringUtil.isBlank((CharSequence)k1) && StringUtil.isBlank((CharSequence)k2)) {
            throw new KeyNotConfiguredException(String.format("%s key is not configured (\u672a\u914d\u7f6e%s)", keyName, keyName));
        }
        return StringUtil.isBlank((CharSequence)k2) ? k1 : k2;
    }
}

