/*
 * Decompiled with CFR 0.152.
 */
package org.violet.commom.crypto.advice;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Parameter;
import lombok.Generated;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.violet.commom.crypto.annotation.decrypt.ApiDecrypt;
import org.violet.commom.crypto.bean.CryptoInfoBean;
import org.violet.commom.crypto.config.ApiCryptoProperties;
import org.violet.commom.crypto.util.ApiCryptoUtil;
import org.violet.common.core.util.Charsets;
import org.violet.common.core.util.JsonUtil;
import org.violet.common.core.util.StringUtil;

public class ApiDecryptParamResolver
implements HandlerMethodArgumentResolver {
    private final ApiCryptoProperties properties;

    public boolean supportsParameter(MethodParameter parameter) {
        return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)parameter.getParameter(), ApiDecrypt.class);
    }

    @Nullable
    public Object resolveArgument(MethodParameter methodParameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        Parameter parameter = methodParameter.getParameter();
        ApiDecrypt apiDecrypt = (ApiDecrypt)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)parameter, ApiDecrypt.class);
        String text = webRequest.getParameter(this.properties.getParamName());
        if (StringUtil.isBlank((CharSequence)text)) {
            return null;
        }
        CryptoInfoBean infoBean = new CryptoInfoBean(apiDecrypt.value(), apiDecrypt.secretKey());
        byte[] textBytes = text.getBytes(Charsets.UTF_8);
        byte[] decryptData = ApiCryptoUtil.decryptData(this.properties, textBytes, infoBean);
        return JsonUtil.readValue((byte[])decryptData, parameter.getType());
    }

    @Generated
    public ApiDecryptParamResolver(ApiCryptoProperties properties) {
        this.properties = properties;
    }
}

